/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime.proxy;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.fabric3.jpa.runtime.proxy.EntityManagerCreationException;
import org.fabric3.jpa.runtime.proxy.EntityManagerService;
import org.fabric3.jpa.runtime.proxy.HibernateProxy;
import org.oasisopen.sca.ServiceRuntimeException;

public class StatefulEntityManagerProxy
implements HibernateProxy,
EntityManager {
    private String unitName;
    private EntityManager em;
    private EntityManagerService emService;
    private TransactionManager tm;

    public StatefulEntityManagerProxy(String unitName, EntityManagerService emService, TransactionManager tm) {
        this.unitName = unitName;
        this.emService = emService;
        this.tm = tm;
    }

    public void persist(Object entity) {
        this.initEntityManager();
        this.em.persist(entity);
    }

    public <T> T merge(T entity) {
        this.initEntityManager();
        return (T)this.em.merge(entity);
    }

    public void remove(Object entity) {
        this.initEntityManager();
        this.em.remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        this.initEntityManager();
        return (T)this.em.find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> tClass, Object o, Map<String, Object> stringObjectMap) {
        this.initEntityManager();
        return (T)this.em.find(tClass, o, stringObjectMap);
    }

    public <T> T find(Class<T> tClass, Object o, LockModeType lockModeType) {
        this.initEntityManager();
        return (T)this.em.find(tClass, o, lockModeType);
    }

    public <T> T find(Class<T> tClass, Object o, LockModeType lockModeType, Map<String, Object> stringObjectMap) {
        this.initEntityManager();
        return (T)this.em.find(tClass, o, lockModeType, stringObjectMap);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        this.initEntityManager();
        return (T)this.em.getReference(entityClass, primaryKey);
    }

    public void flush() {
        this.initEntityManager();
        this.em.flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.initEntityManager();
        this.em.setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        this.initEntityManager();
        return this.em.getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.initEntityManager();
        this.em.lock(entity, lockMode);
    }

    public void lock(Object o, LockModeType lockModeType, Map<String, Object> stringObjectMap) {
        this.initEntityManager();
        this.em.lock(o, lockModeType, stringObjectMap);
    }

    public void refresh(Object entity) {
        this.initEntityManager();
        this.em.remove(entity);
    }

    public void refresh(Object o, Map<String, Object> stringObjectMap) {
        this.initEntityManager();
        this.em.refresh(o, stringObjectMap);
    }

    public void refresh(Object o, LockModeType lockModeType) {
        this.initEntityManager();
        this.em.refresh(o, lockModeType);
    }

    public void refresh(Object o, LockModeType lockModeType, Map<String, Object> stringObjectMap) {
        this.initEntityManager();
        this.em.refresh(o, lockModeType, stringObjectMap);
    }

    public void clear() {
        this.initEntityManager();
        this.em.clear();
    }

    public void detach(Object o) {
        this.initEntityManager();
        this.em.detach(o);
    }

    public boolean contains(Object entity) {
        this.initEntityManager();
        return this.em.contains(entity);
    }

    public LockModeType getLockMode(Object o) {
        this.initEntityManager();
        return this.em.getLockMode(o);
    }

    public void setProperty(String s, Object o) {
        this.initEntityManager();
        this.em.setProperty(s, o);
    }

    public Map<String, Object> getProperties() {
        this.initEntityManager();
        return this.em.getProperties();
    }

    public Query createQuery(String qlString) {
        this.initEntityManager();
        return this.em.createQuery(qlString);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> tCriteriaQuery) {
        this.initEntityManager();
        return this.em.createQuery(tCriteriaQuery);
    }

    public Query createQuery(CriteriaUpdate updateQuery) {
        this.initEntityManager();
        return this.em.createQuery(updateQuery);
    }

    public Query createQuery(CriteriaDelete deleteQuery) {
        this.initEntityManager();
        return this.em.createQuery(deleteQuery);
    }

    public <T> TypedQuery<T> createQuery(String s, Class<T> tClass) {
        this.initEntityManager();
        return this.em.createQuery(s, tClass);
    }

    public Query createNamedQuery(String name) {
        this.initEntityManager();
        return this.em.createNamedQuery(name);
    }

    public <T> TypedQuery<T> createNamedQuery(String s, Class<T> tClass) {
        this.initEntityManager();
        return this.em.createNamedQuery(s, tClass);
    }

    public Query createNativeQuery(String sqlString) {
        this.initEntityManager();
        return this.em.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        this.initEntityManager();
        return this.em.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        this.initEntityManager();
        return this.em.createNativeQuery(sqlString, resultSetMapping);
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        this.initEntityManager();
        return this.em.createNamedStoredProcedureQuery(name);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        this.initEntityManager();
        return this.em.createStoredProcedureQuery(procedureName);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        this.initEntityManager();
        return this.em.createStoredProcedureQuery(procedureName, resultClasses);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        this.initEntityManager();
        return this.em.createStoredProcedureQuery(procedureName, resultSetMappings);
    }

    public void joinTransaction() {
        this.initEntityManager();
        this.em.joinTransaction();
    }

    public boolean isJoinedToTransaction() {
        this.initEntityManager();
        return this.em.isJoinedToTransaction();
    }

    public <T> T unwrap(Class<T> tClass) {
        this.initEntityManager();
        return (T)this.em.unwrap(tClass);
    }

    public Object getDelegate() {
        this.initEntityManager();
        return this.em.getDelegate();
    }

    public void close() {
        this.initEntityManager();
        this.em.close();
    }

    public boolean isOpen() {
        this.initEntityManager();
        return this.em.isOpen();
    }

    public EntityTransaction getTransaction() {
        this.initEntityManager();
        return this.em.getTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        this.initEntityManager();
        return this.em.getEntityManagerFactory();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        this.initEntityManager();
        return this.em.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        this.initEntityManager();
        return this.em.getMetamodel();
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        this.initEntityManager();
        return this.em.createEntityGraph(rootType);
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        this.initEntityManager();
        return this.em.createEntityGraph(graphName);
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        this.initEntityManager();
        return this.em.getEntityGraph(graphName);
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        this.initEntityManager();
        return this.em.getEntityGraphs(entityClass);
    }

    @Override
    public void clearEntityManager() {
        this.em = null;
    }

    private void initEntityManager() {
        if (this.em != null) {
            return;
        }
        try {
            Transaction trx = this.tm.getTransaction();
            if (trx == null) {
                throw new IllegalStateException("A transaction is not active - ensure the component is executing in a managed transaction");
            }
            this.em = this.emService.getEntityManager(this.unitName, this, trx);
        }
        catch (SystemException | EntityManagerCreationException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }
}

