/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime;

import java.net.URI;
import javax.transaction.TransactionManager;
import org.fabric3.jpa.api.EntityManagerFactoryResolver;
import org.fabric3.jpa.api.JpaResolutionException;
import org.fabric3.jpa.api.PersistenceOverrides;
import org.fabric3.jpa.provision.SessionWireTargetDefinition;
import org.fabric3.jpa.runtime.proxy.EntityManagerService;
import org.fabric3.jpa.runtime.proxy.MultiThreadedSessionProxyFactory;
import org.fabric3.jpa.runtime.proxy.StatefulSessionProxyFactory;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.TargetWireAttacher;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.oasisopen.sca.annotation.Reference;

public class SessionWireAttacher
implements TargetWireAttacher<SessionWireTargetDefinition> {
    private EntityManagerFactoryResolver emfResolver;
    private ClassLoaderRegistry registry;
    private TransactionManager tm;
    private EntityManagerService emService;

    public SessionWireAttacher(@Reference EntityManagerService emService, @Reference TransactionManager tm, @Reference EntityManagerFactoryResolver emfResolver, @Reference ClassLoaderRegistry registry) {
        this.emfResolver = emfResolver;
        this.registry = registry;
        this.emService = emService;
        this.tm = tm;
    }

    public ObjectFactory<?> createObjectFactory(SessionWireTargetDefinition definition) throws ContainerException {
        String unitName = definition.getUnitName();
        URI classLoaderId = definition.getClassLoaderId();
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = this.registry.getClassLoader(classLoaderId);
            Thread.currentThread().setContextClassLoader(classLoader);
            PersistenceOverrides overrides = definition.getOverrides();
            this.emfResolver.resolve(unitName, overrides, classLoader);
            if (definition.isMultiThreaded()) {
                MultiThreadedSessionProxyFactory multiThreadedSessionProxyFactory = new MultiThreadedSessionProxyFactory(unitName, this.emService, this.tm);
                return multiThreadedSessionProxyFactory;
            }
            StatefulSessionProxyFactory statefulSessionProxyFactory = new StatefulSessionProxyFactory(unitName, this.emService, this.tm);
            return statefulSessionProxyFactory;
        }
        catch (JpaResolutionException e) {
            throw new ContainerException((Throwable)((Object)e));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public void attach(PhysicalWireSourceDefinition source, SessionWireTargetDefinition target, Wire wire) throws ContainerException {
        throw new UnsupportedOperationException();
    }

    public void detach(PhysicalWireSourceDefinition source, SessionWireTargetDefinition target) throws ContainerException {
        throw new UnsupportedOperationException();
    }
}

