/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime;

import java.net.URI;
import javax.persistence.EntityManagerFactory;
import org.fabric3.jpa.api.EntityManagerFactoryResolver;
import org.fabric3.jpa.api.PersistenceOverrides;
import org.fabric3.jpa.provision.PersistenceUnitWireTargetDefinition;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.TargetWireAttacher;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.objectfactory.SingletonObjectFactory;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.oasisopen.sca.annotation.Reference;

public class PersistenceUnitWireAttacher
implements TargetWireAttacher<PersistenceUnitWireTargetDefinition> {
    private EntityManagerFactoryResolver emfResolver;
    private ClassLoaderRegistry registry;

    public PersistenceUnitWireAttacher(@Reference EntityManagerFactoryResolver emfResolver, @Reference ClassLoaderRegistry registry) {
        this.emfResolver = emfResolver;
        this.registry = registry;
    }

    public void attach(PhysicalWireSourceDefinition source, PersistenceUnitWireTargetDefinition target, Wire wire) throws ContainerException {
        throw new AssertionError();
    }

    public void detach(PhysicalWireSourceDefinition source, PersistenceUnitWireTargetDefinition target) throws ContainerException {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectFactory<?> createObjectFactory(PersistenceUnitWireTargetDefinition target) throws ContainerException {
        String unitName = target.getUnitName();
        URI classLoaderUri = target.getClassLoaderId();
        ClassLoader classLoader = this.registry.getClassLoader(classLoaderUri);
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            PersistenceOverrides overrides = target.getOverrides();
            EntityManagerFactory entityManagerFactory = this.emfResolver.resolve(unitName, overrides, classLoader);
            SingletonObjectFactory singletonObjectFactory = new SingletonObjectFactory((Object)entityManagerFactory);
            return singletonObjectFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

