/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime;

import java.net.URI;
import javax.transaction.TransactionManager;
import org.fabric3.jpa.api.EntityManagerFactoryResolver;
import org.fabric3.jpa.api.PersistenceOverrides;
import org.fabric3.jpa.provision.PersistenceContextWireTargetDefinition;
import org.fabric3.jpa.runtime.proxy.EntityManagerService;
import org.fabric3.jpa.runtime.proxy.MultiThreadedEntityManagerProxyFactory;
import org.fabric3.jpa.runtime.proxy.StatefulEntityManagerProxyFactory;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.TargetWireAttacher;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.oasisopen.sca.annotation.Reference;

public class PersistenceContextWireAttacher
implements TargetWireAttacher<PersistenceContextWireTargetDefinition> {
    private EntityManagerFactoryResolver emfResolver;
    private ClassLoaderRegistry registry;
    private TransactionManager tm;
    private EntityManagerService emService;

    public PersistenceContextWireAttacher(@Reference EntityManagerService emService, @Reference TransactionManager tm, @Reference EntityManagerFactoryResolver emfResolver, @Reference ClassLoaderRegistry registry) {
        this.emfResolver = emfResolver;
        this.registry = registry;
        this.emService = emService;
        this.tm = tm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectFactory<?> createObjectFactory(PersistenceContextWireTargetDefinition definition) throws ContainerException {
        String unitName = definition.getUnitName();
        URI classLoaderId = definition.getClassLoaderId();
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = this.registry.getClassLoader(classLoaderId);
            Thread.currentThread().setContextClassLoader(classLoader);
            PersistenceOverrides overrides = definition.getOverrides();
            this.emfResolver.resolve(unitName, overrides, classLoader);
            if (definition.isMultiThreaded()) {
                MultiThreadedEntityManagerProxyFactory multiThreadedEntityManagerProxyFactory = new MultiThreadedEntityManagerProxyFactory(unitName, this.emService, this.tm);
                return multiThreadedEntityManagerProxyFactory;
            }
            StatefulEntityManagerProxyFactory statefulEntityManagerProxyFactory = new StatefulEntityManagerProxyFactory(unitName, this.emService, this.tm);
            return statefulEntityManagerProxyFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public void attach(PhysicalWireSourceDefinition source, PersistenceContextWireTargetDefinition target, Wire wire) throws ContainerException {
        throw new UnsupportedOperationException();
    }

    public void detach(PhysicalWireSourceDefinition source, PersistenceContextWireTargetDefinition target) throws ContainerException {
        throw new UnsupportedOperationException();
    }
}

