/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.override;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.jpa.api.PersistenceOverrides;
import org.fabric3.jpa.override.DuplicateOverridesException;
import org.fabric3.jpa.override.OverrideRegistry;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionServiceListener;
import org.oasisopen.sca.annotation.Service;

@Service(value={OverrideRegistry.class})
public class OverrideRegistryImpl
implements OverrideRegistry,
ContributionServiceListener {
    private Map<URI, List<PersistenceOverrides>> index = new ConcurrentHashMap<URI, List<PersistenceOverrides>>();
    private Map<String, PersistenceOverrides> cache = new ConcurrentHashMap<String, PersistenceOverrides>();

    @Override
    public void register(URI contributionURI, PersistenceOverrides overrides) throws DuplicateOverridesException {
        String unitName = overrides.getUnitName();
        if (this.cache.containsKey(unitName)) {
            throw new DuplicateOverridesException(unitName);
        }
        List<PersistenceOverrides> list = this.index.get(contributionURI);
        if (list == null) {
            list = new ArrayList<PersistenceOverrides>();
            this.index.put(contributionURI, list);
        }
        list.add(overrides);
        this.cache.put(unitName, overrides);
    }

    @Override
    public PersistenceOverrides resolve(String unitName) {
        return this.cache.get(unitName);
    }

    public void onUninstall(Contribution contribution) {
        List<PersistenceOverrides> overrides = this.index.remove(contribution.getUri());
        if (overrides != null) {
            for (PersistenceOverrides override : overrides) {
                this.cache.remove(override.getUnitName());
            }
        }
    }

    public void onStore(Contribution contribution) {
    }

    public void onProcessManifest(Contribution contribution) {
    }

    public void onInstall(Contribution contribution) {
    }

    public void onUpdate(Contribution contribution) {
    }

    public void onRemove(Contribution contribution) {
    }
}

