/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.introspection;

import java.net.URI;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.jpa.api.PersistenceOverrides;
import org.fabric3.jpa.introspection.DuplicateOverrides;
import org.fabric3.jpa.override.DuplicateOverridesException;
import org.fabric3.jpa.override.OverrideRegistry;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class PersistenceUnitOverridesElementLoader
implements TypeLoader<ModelObject> {
    private static final QName QNAME = new QName("urn:fabric3.org", "persistenceUnit");
    private LoaderRegistry loaderRegistry;
    private OverrideRegistry overrideRegistry;

    public PersistenceUnitOverridesElementLoader(@Reference LoaderRegistry loaderRegistry, @Reference OverrideRegistry overrideRegistry) {
        this.loaderRegistry = loaderRegistry;
        this.overrideRegistry = overrideRegistry;
    }

    @Init
    public void init() {
        this.loaderRegistry.registerLoader(QNAME, (TypeLoader)this);
    }

    @Destroy
    public void destroy() {
        this.loaderRegistry.unregisterLoader(QNAME);
    }

    public ModelObject load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute error = new MissingAttribute("Persistence unit name not specified", startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)error);
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        while (true) {
            int val = reader.nextTag();
            switch (val) {
                case 1: {
                    if (!"property".equals(reader.getName().getLocalPart())) break;
                    String propertyName = reader.getAttributeValue(null, "name");
                    String propertyValue = reader.getAttributeValue(null, "value");
                    properties.put(propertyName, propertyValue);
                    break;
                }
                case 2: {
                    if (!"persistenceUnit".equals(reader.getName().getLocalPart())) break;
                    try {
                        URI uri = context.getContributionUri();
                        PersistenceOverrides overrides = new PersistenceOverrides(name, properties);
                        this.overrideRegistry.register(uri, overrides);
                    }
                    catch (DuplicateOverridesException e) {
                        DuplicateOverrides error = new DuplicateOverrides(name, startLocation);
                        context.addError((ValidationFailure)error);
                    }
                    return null;
                }
            }
        }
    }
}

