/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.proxy.jdk.wire;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.implementation.proxy.jdk.wire.CallbackWireSupplier;
import org.fabric3.implementation.proxy.jdk.wire.JDKInvocationHandler;
import org.fabric3.implementation.proxy.jdk.wire.JDKWireProxyService;
import org.fabric3.implementation.proxy.jdk.wire.MultiThreadedCallbackInvocationHandler;
import org.fabric3.implementation.proxy.jdk.wire.StatefulCallbackInvocationHandler;
import org.fabric3.implementation.proxy.jdk.wire.WireSupplier;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalOperation;

public class JDKWireProxyServiceImpl
implements JDKWireProxyService {
    public boolean isDefault() {
        return true;
    }

    public <T> Supplier<T> createSupplier(Class<T> interfaze, Wire wire, String callbackUri) {
        Map<Method, InvocationChain> mappings = this.createInterfaceToWireMapping(interfaze, wire);
        return new WireSupplier<T>(interfaze, callbackUri, this, mappings);
    }

    public <T> Supplier<T> createCallbackSupplier(Class<T> interfaze, boolean multiThreaded, URI callbackUri, Wire wire) {
        Map<Method, InvocationChain> operationMappings = this.createInterfaceToWireMapping(interfaze, wire);
        HashMap<String, Map<Method, InvocationChain>> mappings = new HashMap<String, Map<Method, InvocationChain>>();
        mappings.put(callbackUri.toString(), operationMappings);
        return new CallbackWireSupplier<T>(interfaze, multiThreaded, this, mappings);
    }

    public <T> Supplier<?> updateCallbackSupplier(Supplier<?> supplier, Class<T> interfaze, boolean multiThreaded, URI callbackUri, Wire wire) {
        if (!(supplier instanceof CallbackWireSupplier)) {
            return this.createCallbackSupplier(interfaze, multiThreaded, callbackUri, wire);
        }
        CallbackWireSupplier callbackFactory = (CallbackWireSupplier)supplier;
        Map<Method, InvocationChain> operationMappings = this.createInterfaceToWireMapping(interfaze, wire);
        callbackFactory.updateMappings(callbackUri.toString(), operationMappings);
        return callbackFactory;
    }

    @Override
    public <T> T createProxy(Class<T> interfaze, String callbackUri, Map<Method, InvocationChain> mappings) {
        JDKInvocationHandler<T> handler = new JDKInvocationHandler<T>(interfaze, callbackUri, mappings);
        return handler.getService();
    }

    @Override
    public <T> T createMultiThreadedCallbackProxy(Class<T> interfaze, Map<String, Map<Method, InvocationChain>> mappings) {
        ClassLoader cl = interfaze.getClassLoader();
        MultiThreadedCallbackInvocationHandler handler = new MultiThreadedCallbackInvocationHandler(mappings);
        return interfaze.cast(Proxy.newProxyInstance(cl, new Class[]{interfaze}, handler));
    }

    @Override
    public <T> T createCallbackProxy(Class<T> interfaze, Map<Method, InvocationChain> mapping) {
        ClassLoader cl = interfaze.getClassLoader();
        StatefulCallbackInvocationHandler handler = new StatefulCallbackInvocationHandler(mapping);
        return interfaze.cast(Proxy.newProxyInstance(cl, new Class[]{interfaze}, handler));
    }

    private Map<Method, InvocationChain> createInterfaceToWireMapping(Class<?> interfaze, Wire wire) {
        List invocationChains = wire.getInvocationChains();
        HashMap<Method, InvocationChain> chains = new HashMap<Method, InvocationChain>(invocationChains.size());
        for (InvocationChain chain : invocationChains) {
            PhysicalOperation operation = chain.getPhysicalOperation();
            try {
                Method method = this.findMethod(interfaze, operation);
                chains.put(method, chain);
            }
            catch (NoSuchMethodException e) {
                throw new Fabric3Exception(operation.getName());
            }
            catch (ClassNotFoundException e) {
                throw new Fabric3Exception((Throwable)e);
            }
        }
        return chains;
    }

    private Method findMethod(Class<?> clazz, PhysicalOperation operation) throws NoSuchMethodException, ClassNotFoundException {
        String name = operation.getName();
        List params = operation.getSourceParameterTypes();
        return clazz.getMethod(name, params.toArray(new Class[params.size()]));
    }
}

