/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.runtime.message;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.fabric3.api.binding.zeromq.model.ZeroMQMetadata;
import org.fabric3.binding.zeromq.runtime.context.ContextManager;
import org.fabric3.binding.zeromq.runtime.message.SocketHelper;
import org.fabric3.binding.zeromq.runtime.message.SocketMultiplexer;
import org.fabric3.spi.federation.addressing.SocketAddress;
import org.fabric3.spi.host.Port;
import org.zeromq.ZMQ;

public class RoundRobinSocketMultiplexer
implements SocketMultiplexer {
    private ContextManager manager;
    private int socketType;
    private ZeroMQMetadata metadata;
    private int index;
    private ZMQ.Socket[] zmqSockets;
    private Map<SocketAddress, ZMQ.Socket> sockets;
    private String seed = UUID.randomUUID().toString();

    public RoundRobinSocketMultiplexer(ContextManager manager, int socketType, ZeroMQMetadata metadata) {
        this.manager = manager;
        this.socketType = socketType;
        this.metadata = metadata;
        this.sockets = new HashMap<SocketAddress, ZMQ.Socket>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(List<SocketAddress> addresses) {
        if (this.sockets.isEmpty()) {
            if (addresses.size() == 1) {
                SocketAddress address = addresses.get(0);
                String addressString = address.toProtocolString();
                this.manager.reserve(this.getClass().getName() + ":" + this.seed + addressString);
                ZMQ.Socket socket = this.manager.getContext().socket(this.socketType);
                SocketHelper.configure(socket, this.metadata);
                address.getPort().bind(Port.TYPE.TCP);
                socket.connect(addressString);
                this.sockets.put(address, socket);
            } else {
                for (SocketAddress address : addresses) {
                    String addressString = address.toProtocolString();
                    this.manager.reserve(this.getClass().getName() + ":" + this.seed + addressString);
                    ZMQ.Socket socket = this.manager.getContext().socket(this.socketType);
                    SocketHelper.configure(socket, this.metadata);
                    address.getPort().bind(Port.TYPE.TCP);
                    socket.connect(addressString);
                    this.sockets.put(address, socket);
                }
            }
        } else {
            HashSet<SocketAddress> intersection = new HashSet<SocketAddress>(addresses);
            intersection.retainAll(this.sockets.keySet());
            HashSet<SocketAddress> toClose = new HashSet<SocketAddress>(this.sockets.keySet());
            toClose.removeAll(addresses);
            HashSet<SocketAddress> toAdd = new HashSet<SocketAddress>(addresses);
            toAdd.removeAll(this.sockets.keySet());
            try {
                for (SocketAddress address : toClose) {
                    this.sockets.remove(address).close();
                }
            }
            finally {
                for (SocketAddress address : toClose) {
                    this.manager.release(this.getClass().getName() + ":" + this.seed + address.toProtocolString());
                }
            }
            for (SocketAddress address : toAdd) {
                String addressString = address.toProtocolString();
                this.manager.reserve(this.getClass().getName() + ":" + this.seed + addressString);
                ZMQ.Socket socket = this.manager.getContext().socket(this.socketType);
                SocketHelper.configure(socket, this.metadata);
                address.getPort().bind(Port.TYPE.TCP);
                socket.connect(addressString);
                this.sockets.put(address, socket);
            }
        }
        this.zmqSockets = new ZMQ.Socket[this.sockets.size()];
        this.sockets.values().toArray(this.zmqSockets);
    }

    @Override
    public ZMQ.Socket get() {
        if (this.index == this.zmqSockets.length) {
            this.index = 0;
        }
        return this.zmqSockets[this.index++];
    }

    @Override
    public Collection<ZMQ.Socket> getAll() {
        return this.sockets.values();
    }

    @Override
    public boolean isAvailable() {
        return this.zmqSockets.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            for (ZMQ.Socket socket : this.sockets.values()) {
                socket.close();
            }
        }
        catch (Throwable throwable) {
            for (SocketAddress address : this.sockets.keySet()) {
                this.manager.release(this.getClass().getName() + ":" + this.seed + address.toProtocolString());
            }
            throw throwable;
        }
        for (SocketAddress address : this.sockets.keySet()) {
            this.manager.release(this.getClass().getName() + ":" + this.seed + address.toProtocolString());
        }
    }
}

