/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.runtime.message;

import java.util.UUID;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.management.OperationType;
import org.fabric3.api.binding.zeromq.model.ZeroMQMetadata;
import org.fabric3.binding.zeromq.runtime.context.ContextManager;
import org.fabric3.binding.zeromq.runtime.message.Publisher;
import org.fabric3.binding.zeromq.runtime.message.SocketHelper;
import org.fabric3.spi.federation.addressing.SocketAddress;
import org.fabric3.spi.host.Port;
import org.zeromq.ZMQ;

@Management
public class NonReliableSingleThreadPublisher
implements Publisher {
    private ContextManager manager;
    private SocketAddress address;
    private ZeroMQMetadata metadata;
    private ZMQ.Socket socket;
    private final String id;

    public NonReliableSingleThreadPublisher(ContextManager manager, SocketAddress address, ZeroMQMetadata metadata) {
        this.manager = manager;
        this.address = address;
        this.metadata = metadata;
        this.id = this.getClass().getName() + ":" + UUID.randomUUID().toString();
    }

    @Override
    @ManagementOperation(type=OperationType.POST)
    public void start() {
        this.manager.reserve(this.id);
        this.socket = this.manager.getContext().socket(1);
        SocketHelper.configure(this.socket, this.metadata);
        this.address.getPort().bind(Port.TYPE.TCP);
        this.socket.bind(this.address.toProtocolString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagementOperation(type=OperationType.POST)
    public void stop() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            finally {
                this.socket = null;
                this.manager.release(this.id);
            }
        }
    }

    @ManagementOperation
    public String getAddress() {
        return this.address.toString();
    }

    @Override
    public void publish(byte[] message) {
        if (this.socket == null) {
            return;
        }
        this.socket.send(message, 0);
    }

    @Override
    public void publish(byte[][] message) {
        if (this.socket == null) {
            return;
        }
        int length = message.length;
        for (int i = 0; i < length - 1; ++i) {
            byte[] bytes = message[i];
            this.socket.send(bytes, 2);
        }
        this.socket.send(message[length - 1], 0);
    }
}

