/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.runtime.message;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.binding.zeromq.model.ZeroMQMetadata;
import org.fabric3.binding.zeromq.runtime.MessagingMonitor;
import org.fabric3.binding.zeromq.runtime.context.ContextManager;
import org.fabric3.binding.zeromq.runtime.message.AbstractReceiver;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.MessageCache;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.federation.addressing.SocketAddress;
import org.zeromq.ZMQ;

@Management
public class NonReliableOneWayReceiver
extends AbstractReceiver
implements Thread.UncaughtExceptionHandler {
    public NonReliableOneWayReceiver(ContextManager manager, SocketAddress address, List<InvocationChain> chains, ExecutorService executorService, ZeroMQMetadata metadata, MessagingMonitor monitor) {
        super(manager, address, chains, 7, metadata, executorService, monitor);
    }

    @Override
    protected boolean invoke(ZMQ.Socket socket) {
        final byte[][] frames = new byte[3][];
        int i = 1;
        frames[0] = socket.recv(0);
        while (socket.hasReceiveMore()) {
            if (i > 2) {
                this.monitor.error("Invalid message: received more than three frames");
                return false;
            }
            frames[i] = socket.recv(0);
            ++i;
        }
        this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Message request = MessageCache.getAndResetMessage();
                try {
                    request.setBody((Object)frames[0]);
                    int methodIndex = ByteBuffer.wrap(frames[1]).getInt();
                    WorkContext context = NonReliableOneWayReceiver.this.setWorkContext(frames[2]);
                    request.setWorkContext(context);
                    Interceptor interceptor = NonReliableOneWayReceiver.this.interceptors[methodIndex];
                    interceptor.invoke(request);
                }
                finally {
                    request.reset();
                }
            }
        });
        return true;
    }

    @Override
    protected void response(ZMQ.Socket socket) {
    }
}

