/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.runtime.management;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.binding.zeromq.runtime.management.ManagementMonitor;
import org.fabric3.binding.zeromq.runtime.management.ZeroMQManagementService;
import org.fabric3.binding.zeromq.runtime.message.Publisher;
import org.fabric3.binding.zeromq.runtime.message.Receiver;
import org.fabric3.binding.zeromq.runtime.message.Sender;
import org.fabric3.binding.zeromq.runtime.message.Subscriber;
import org.fabric3.spi.management.ManagementException;
import org.fabric3.spi.management.ManagementService;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Management(path="/runtime/transports/zeromq", description="Manages ZeroMQ infrastructure")
public class ZeroMQManagementServiceImpl
implements ZeroMQManagementService {
    private static final String SUBSCRIBERS_PATH = "transports/zeromq/subscribers/";
    private static final String PUBLISHERS_PATH = "transports/zeromq/publishers/";
    private static final String SENDERS_PATH = "transports/zeromq/senders/";
    private static final String RECEIVERS_PATH = "transports/zeromq/receivers/";
    private Set<String> subscribers = new HashSet<String>();
    private Set<String> publishers = new HashSet<String>();
    private Set<String> senders = new HashSet<String>();
    private Set<String> receivers = new HashSet<String>();
    private ManagementService managementService;
    private ManagementMonitor monitor;

    public ZeroMQManagementServiceImpl(@Reference ManagementService managementService, @Monitor ManagementMonitor monitor) {
        this.managementService = managementService;
        this.monitor = monitor;
    }

    @ManagementOperation
    public Set<String> getSubscribers() {
        return this.subscribers;
    }

    @ManagementOperation
    public Set<String> getPublishers() {
        return this.publishers;
    }

    @ManagementOperation
    public Set<String> getSenders() {
        return this.senders;
    }

    @ManagementOperation
    public Set<String> getReceivers() {
        return this.receivers;
    }

    @Override
    public void register(String channelName, URI subscriberId, Subscriber subscriber) {
        try {
            this.subscribers.add(channelName);
            this.managementService.export(SUBSCRIBERS_PATH + channelName, "", "", (Object)subscriber);
        }
        catch (ManagementException e) {
            this.monitor.error("Error registering subscriber for channel " + channelName, e);
        }
    }

    @Override
    public void unregister(String channelName, URI subscriberId) {
        try {
            this.subscribers.remove(channelName);
            this.managementService.remove(SUBSCRIBERS_PATH + channelName, "");
        }
        catch (ManagementException e) {
            this.monitor.error("Error unregistering subscriber for channel " + channelName, e);
        }
    }

    @Override
    public void register(String channelName, Publisher publisher) {
        this.publishers.add(channelName);
        try {
            this.managementService.export(PUBLISHERS_PATH + channelName, "", "", (Object)publisher);
        }
        catch (ManagementException e) {
            this.monitor.error("Error registering publisher for channel " + channelName, e);
        }
    }

    @Override
    public void unregister(String channelName) {
        try {
            this.publishers.remove(channelName);
            this.managementService.remove(PUBLISHERS_PATH + channelName, "");
        }
        catch (ManagementException e) {
            this.monitor.error("Error unregistering publisher for channel " + channelName, e);
        }
    }

    @Override
    public void registerSender(String id, Sender sender) {
        this.senders.add(id);
        try {
            this.managementService.export(SENDERS_PATH + id, "", "", (Object)sender);
        }
        catch (ManagementException e) {
            this.monitor.error("Error registering publisher for channel " + id, e);
        }
    }

    @Override
    public void unregisterSender(String id) {
        this.senders.remove(id);
        try {
            this.managementService.remove(SENDERS_PATH + id, "");
        }
        catch (ManagementException e) {
            this.monitor.error("Error unregistering sender: " + id, e);
        }
    }

    @Override
    public void registerReceiver(String id, Receiver receiver) {
        this.receivers.add(id);
        try {
            this.managementService.export(RECEIVERS_PATH + id, "", "", (Object)receiver);
        }
        catch (ManagementException e) {
            this.monitor.error("Error registering receiver: " + id, e);
        }
    }

    @Override
    public void unregisterReceiver(String id) {
        this.receivers.remove(id);
        try {
            this.managementService.remove(RECEIVERS_PATH + id, "");
        }
        catch (ManagementException e) {
            this.monitor.error("Error unregistering receiver: " + id, e);
        }
    }
}

