/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.runtime.interceptor;

import org.fabric3.binding.zeromq.runtime.message.OneWaySender;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.MessageImpl;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.wire.Interceptor;

public class OneWayInterceptor
implements Interceptor {
    private static final Message ONE_WAY_RESPONSE = new MessageImpl();
    private int index;
    private OneWaySender sender;

    public OneWayInterceptor(int index, OneWaySender sender) {
        this.index = index;
        this.sender = sender;
    }

    public Message invoke(Message msg) {
        byte[] body = (byte[])msg.getBody();
        WorkContext workContext = msg.getWorkContext();
        this.sender.send(body, this.index, workContext);
        return ONE_WAY_RESPONSE;
    }

    public void setNext(Interceptor next) {
        throw new IllegalStateException("This interceptor must be the last one in an target interceptor chain");
    }

    public Interceptor getNext() {
        return null;
    }
}

