/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.runtime.context;

import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.binding.zeromq.runtime.context.ContextManager;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;
import org.zeromq.ZMQ;

@EagerInit
public class ContextManagerImpl
implements ContextManager {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private ZMQ.Context context;
    private ZMQ.Socket controlSocket;
    private Set<String> leases = new ConcurrentSkipListSet<String>();
    private final Object termMonitor = new Object();
    @Reference
    protected HostInfo hostInfo;

    @Override
    public ZMQ.Context getContext() {
        return this.context;
    }

    @Override
    public ZMQ.Socket createControlSocket() {
        ZMQ.Socket controlSocket = this.context.socket(2);
        controlSocket.setLinger(0L);
        controlSocket.subscribe(EMPTY_BYTES);
        controlSocket.connect("inproc://fabric3");
        return controlSocket;
    }

    @Override
    public void reserve(String id) {
        this.leases.add(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(String id) {
        Object object = this.termMonitor;
        synchronized (object) {
            this.leases.remove(id);
            this.termMonitor.notifyAll();
        }
    }

    @Init
    public void init() {
        this.loadLibrary(this.hostInfo);
        this.context = ZMQ.context((int)1);
        this.controlSocket = this.context.socket(1);
        this.controlSocket.bind("inproc://fabric3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Destroy
    public void destroy() {
        if (this.controlSocket != null) {
            this.controlSocket.send(new byte[0], 0);
        }
        while (!this.leases.isEmpty()) {
            Object object = this.termMonitor;
            synchronized (object) {
                if (this.leases.isEmpty()) {
                    break;
                }
                try {
                    this.termMonitor.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (this.controlSocket != null) {
            this.controlSocket.close();
        }
        this.context.term();
    }

    protected void loadLibrary(HostInfo hostInfo) {
        if (hostInfo == null) {
            return;
        }
        if (this.getClass().getClassLoader().getResource("org/codehaus/fabric3/jeromq") != null) {
            return;
        }
        String osName = hostInfo.getOperatingSystem().getName().toLowerCase();
        if (osName == null) {
            return;
        }
        for (ZMQLibraryInitializer lib : ZMQLibraryInitializer.values()) {
            if (!osName.toLowerCase().contains(lib.name().toLowerCase())) continue;
            lib.loadLibrary();
            return;
        }
    }

    protected static enum ZMQLibraryInitializer {
        WINDOWS("libzmq-v120-mt-3_2_4"),
        LINUX("zmq"),
        OTHER("");

        private String libName;

        private ZMQLibraryInitializer(String libName) {
            this.libName = libName;
        }

        private void loadLibrary() {
            if (!this.equals((Object)OTHER)) {
                System.loadLibrary(this.libName);
            }
        }
    }
}

