/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.runtime;

import java.net.URI;
import java.util.List;
import org.fabric3.binding.zeromq.provision.ZeroMQWireTargetDefinition;
import org.fabric3.binding.zeromq.runtime.ZeroMQAttacherHelper;
import org.fabric3.binding.zeromq.runtime.ZeroMQWireBroker;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.TargetWireAttacher;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.oasisopen.sca.annotation.Reference;

public class ZeroMQTargetAttacher
implements TargetWireAttacher<ZeroMQWireTargetDefinition> {
    private ZeroMQWireBroker broker;
    private ClassLoaderRegistry registry;

    public ZeroMQTargetAttacher(@Reference ZeroMQWireBroker broker, @Reference ClassLoaderRegistry registry) {
        this.broker = broker;
        this.registry = registry;
    }

    public void attach(PhysicalWireSourceDefinition source, ZeroMQWireTargetDefinition target, Wire wire) throws ContainerException {
        URI sourceUri = source.getUri();
        String id = sourceUri.getPath().substring(1) + "/" + sourceUri.getFragment();
        URI targetUri = target.getUri();
        ClassLoader loader = this.registry.getClassLoader(target.getClassLoaderId());
        List<InvocationChain> chains = ZeroMQAttacherHelper.sortChains(wire);
        this.broker.connectToSender(id, targetUri, chains, target.getMetadata(), loader);
    }

    public void detach(PhysicalWireSourceDefinition source, ZeroMQWireTargetDefinition target) throws ContainerException {
        String id = source.getUri().toString();
        URI uri = target.getUri();
        this.broker.releaseSender(id, uri);
    }

    public ObjectFactory<?> createObjectFactory(ZeroMQWireTargetDefinition target) throws ContainerException {
        throw new UnsupportedOperationException();
    }
}

