/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.runtime;

import java.net.URI;
import java.util.List;
import org.fabric3.api.binding.zeromq.model.ZeroMQMetadata;
import org.fabric3.binding.zeromq.provision.ZeroMQWireSourceDefinition;
import org.fabric3.binding.zeromq.runtime.ZeroMQAttacherHelper;
import org.fabric3.binding.zeromq.runtime.ZeroMQWireBroker;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.SourceWireAttacher;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.oasisopen.sca.annotation.Reference;

public class ZeroMQSourceAttacher
implements SourceWireAttacher<ZeroMQWireSourceDefinition> {
    private ZeroMQWireBroker broker;
    private ClassLoaderRegistry registry;

    public ZeroMQSourceAttacher(@Reference ZeroMQWireBroker broker, @Reference ClassLoaderRegistry registry) {
        this.broker = broker;
        this.registry = registry;
    }

    public void attach(ZeroMQWireSourceDefinition source, PhysicalWireTargetDefinition target, Wire wire) throws ContainerException {
        URI uri = source.getCallbackUri() != null ? source.getCallbackUri() : target.getUri();
        ClassLoader loader = this.registry.getClassLoader(target.getClassLoaderId());
        List<InvocationChain> chains = ZeroMQAttacherHelper.sortChains(wire);
        ZeroMQMetadata metadata = source.getMetadata();
        this.broker.connectToReceiver(uri, chains, metadata, loader);
    }

    public void detach(ZeroMQWireSourceDefinition source, PhysicalWireTargetDefinition target) throws ContainerException {
        URI uri = source.getCallbackUri() != null ? source.getCallbackUri() : target.getUri();
        this.broker.releaseReceiver(uri);
    }

    public void attachObjectFactory(ZeroMQWireSourceDefinition source, ObjectFactory<?> objectFactory, PhysicalWireTargetDefinition target) throws ContainerException {
        throw new UnsupportedOperationException();
    }

    public void detachObjectFactory(ZeroMQWireSourceDefinition source, PhysicalWireTargetDefinition target) throws ContainerException {
        throw new UnsupportedOperationException();
    }
}

