/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.runtime;

import org.fabric3.api.binding.zeromq.model.ZeroMQMetadata;
import org.fabric3.binding.zeromq.provision.ZeroMQConnectionTargetDefinition;
import org.fabric3.binding.zeromq.runtime.ZeroMQPubSubBroker;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.TargetConnectionAttacher;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.oasisopen.sca.annotation.Reference;

public class ZeroMQConnectionTargetAttacher
implements TargetConnectionAttacher<ZeroMQConnectionTargetDefinition> {
    private ZeroMQPubSubBroker broker;
    private ClassLoaderRegistry registry;

    public ZeroMQConnectionTargetAttacher(@Reference ZeroMQPubSubBroker broker, @Reference ClassLoaderRegistry registry) {
        this.broker = broker;
        this.registry = registry;
    }

    public void attach(PhysicalConnectionSourceDefinition source, ZeroMQConnectionTargetDefinition target, ChannelConnection connection) throws ContainerException {
        ZeroMQMetadata metadata = target.getMetadata();
        String connectionId = source.getUri().toString();
        ClassLoader loader = this.registry.getClassLoader(target.getClassLoaderId());
        boolean dedicatedThread = target.isDedicatedThread();
        this.broker.connect(connectionId, metadata, dedicatedThread, connection, loader);
    }

    public void detach(PhysicalConnectionSourceDefinition source, ZeroMQConnectionTargetDefinition target) throws ContainerException {
        ZeroMQMetadata metadata = target.getMetadata();
        String connectionId = source.getUri().toString();
        this.broker.release(connectionId, metadata);
    }
}

