/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.runtime;

import java.net.URI;
import org.fabric3.api.binding.zeromq.model.ZeroMQMetadata;
import org.fabric3.binding.zeromq.provision.ZeroMQConnectionSourceDefinition;
import org.fabric3.binding.zeromq.runtime.ZeroMQPubSubBroker;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.SourceConnectionAttacher;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.oasisopen.sca.annotation.Reference;

public class ZeroMQConnectionSourceAttacher
implements SourceConnectionAttacher<ZeroMQConnectionSourceDefinition> {
    private ZeroMQPubSubBroker broker;
    private ClassLoaderRegistry registry;

    public ZeroMQConnectionSourceAttacher(@Reference ZeroMQPubSubBroker broker, @Reference ClassLoaderRegistry registry) {
        this.broker = broker;
        this.registry = registry;
    }

    public void attach(ZeroMQConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target, ChannelConnection connection) throws ContainerException {
        ClassLoader loader = this.registry.getClassLoader(source.getClassLoaderId());
        URI subscriberId = source.getUri();
        ZeroMQMetadata metadata = source.getMetadata();
        this.broker.subscribe(subscriberId, metadata, connection, loader);
    }

    public void detach(ZeroMQConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target) throws ContainerException {
        ZeroMQMetadata metadata = source.getMetadata();
        URI subscriberId = source.getUri();
        this.broker.unsubscribe(subscriberId, metadata);
    }
}

