/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.provider;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.api.binding.zeromq.model.ZeroMQBindingDefinition;
import org.fabric3.api.binding.zeromq.model.ZeroMQMetadata;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.spi.domain.generator.binding.BindingMatchResult;
import org.fabric3.spi.domain.generator.binding.BindingProvider;
import org.fabric3.spi.domain.generator.binding.BindingSelectionException;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.type.remote.RemoteServiceContract;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.Property;

public class ZeroMQBindingProvider
implements BindingProvider {
    private static final BindingMatchResult MATCH = new BindingMatchResult(true, ZeroMQBindingDefinition.BINDING_0MQ);
    private static final BindingMatchResult NO_MATCH = new BindingMatchResult(false, ZeroMQBindingDefinition.BINDING_0MQ);
    private boolean enabled = true;
    private long highWater = -1L;
    private long multicastRate = -1L;
    private long multicastRecovery = -1L;
    private long sendBuffer = -1L;
    private long receiveBuffer = -1L;

    @Property(required=false)
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Property(required=false)
    public void setHighWater(long highWater) {
        this.highWater = highWater;
    }

    @Property(required=false)
    public void setMulticastRate(long multicastRate) {
        this.multicastRate = multicastRate;
    }

    @Property(required=false)
    public void setMulticastRecovery(long multicastRecovery) {
        this.multicastRecovery = multicastRecovery;
    }

    @Property(required=false)
    public void setSendBuffer(long sendBuffer) {
        this.sendBuffer = sendBuffer;
    }

    @Property(required=false)
    public void setReceiveBuffer(long receiveBuffer) {
        this.receiveBuffer = receiveBuffer;
    }

    public QName getType() {
        return ZeroMQBindingDefinition.BINDING_0MQ;
    }

    public BindingMatchResult canBind(LogicalWire wire) {
        return !this.enabled ? NO_MATCH : MATCH;
    }

    public BindingMatchResult canBind(LogicalService service) {
        return !this.enabled ? NO_MATCH : MATCH;
    }

    public BindingMatchResult canBind(LogicalChannel channel) {
        return !this.enabled ? NO_MATCH : MATCH;
    }

    public void bind(LogicalService service) {
        QName deployable = ((LogicalComponent)service.getParent()).getDeployable();
        ZeroMQMetadata metadata = this.createMetadata();
        ZeroMQBindingDefinition serviceDefinition = new ZeroMQBindingDefinition("binding.zeromq", metadata);
        LogicalBinding serviceBinding = new LogicalBinding((BindingDefinition)serviceDefinition, (Bindable)service, deployable);
        serviceBinding.setAssigned(true);
        service.addBinding(serviceBinding);
        ServiceContract targetContract = service.getDefinition().getServiceContract();
        if (targetContract.getCallbackContract() != null) {
            ZeroMQMetadata callbackMetadata = this.createMetadata();
            ZeroMQBindingDefinition callbackServiceDefinition = new ZeroMQBindingDefinition("binding.zeromq.callback", callbackMetadata);
            LogicalBinding callbackServiceBinding = new LogicalBinding((BindingDefinition)callbackServiceDefinition, (Bindable)service, deployable);
            callbackServiceBinding.setAssigned(true);
            service.addCallbackBinding(callbackServiceBinding);
        }
    }

    public void bind(LogicalWire wire) throws BindingSelectionException {
        ServiceContract targetContract;
        LogicalReference source = wire.getSource().getLeafReference();
        LogicalService target = wire.getTarget().getLeafService();
        QName deployable = ((LogicalComponent)source.getParent()).getDeployable();
        ZeroMQMetadata metadata = this.createMetadata();
        ZeroMQBindingDefinition referenceDefinition = new ZeroMQBindingDefinition("binding.zeromq", metadata);
        LogicalBinding referenceBinding = new LogicalBinding((BindingDefinition)referenceDefinition, (Bindable)source, deployable);
        referenceDefinition.setTargetUri(URI.create(UriHelper.getBaseName((URI)target.getUri())));
        referenceBinding.setAssigned(true);
        source.addBinding(referenceBinding);
        boolean bindTarget = this.bindTarget(target);
        if (bindTarget) {
            ZeroMQBindingDefinition serviceDefinition = new ZeroMQBindingDefinition("binding.zeromq", metadata);
            LogicalBinding serviceBinding = new LogicalBinding((BindingDefinition)serviceDefinition, (Bindable)target, deployable);
            serviceBinding.setAssigned(true);
            target.addBinding(serviceBinding);
        }
        if ((targetContract = target.getDefinition().getServiceContract()).getCallbackContract() != null) {
            ZeroMQMetadata callbackMetadata = this.createMetadata();
            ZeroMQBindingDefinition callbackReferenceDefinition = new ZeroMQBindingDefinition("binding.zeromq.callback", callbackMetadata);
            LogicalBinding callbackReferenceBinding = new LogicalBinding((BindingDefinition)callbackReferenceDefinition, (Bindable)source, deployable);
            callbackReferenceBinding.setAssigned(true);
            source.addCallbackBinding(callbackReferenceBinding);
            if (bindTarget) {
                ZeroMQBindingDefinition callbackServiceDefinition = new ZeroMQBindingDefinition("binding.zeromq.callback", callbackMetadata);
                LogicalBinding callbackServiceBinding = new LogicalBinding((BindingDefinition)callbackServiceDefinition, (Bindable)target, deployable);
                callbackServiceBinding.setAssigned(true);
                target.addCallbackBinding(callbackServiceBinding);
            }
        }
    }

    public void bind(LogicalChannel channel) throws BindingSelectionException {
        ZeroMQMetadata metadata = this.createMetadata();
        metadata.setChannelName(channel.getDefinition().getName());
        ZeroMQBindingDefinition definition = new ZeroMQBindingDefinition("binding.zeromq", metadata);
        LogicalBinding binding = new LogicalBinding((BindingDefinition)definition, (Bindable)channel);
        channel.addBinding(binding);
    }

    private boolean bindTarget(LogicalService target) {
        if (target.getServiceContract() instanceof RemoteServiceContract) {
            return false;
        }
        for (LogicalBinding binding : target.getBindings()) {
            if (!binding.isAssigned()) continue;
            return false;
        }
        return true;
    }

    private ZeroMQMetadata createMetadata() {
        ZeroMQMetadata metadata = new ZeroMQMetadata();
        metadata.setHighWater(this.highWater);
        metadata.setMulticastRate(this.multicastRate);
        metadata.setMulticastRecovery(this.multicastRecovery);
        metadata.setReceiveBuffer(this.receiveBuffer);
        metadata.setSendBuffer(this.sendBuffer);
        return metadata;
    }
}

