/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.introspection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import org.fabric3.api.binding.zeromq.annotation.ZeroMQ;
import org.fabric3.api.binding.zeromq.model.SocketAddressDefinition;
import org.fabric3.api.binding.zeromq.model.ZeroMQBindingDefinition;
import org.fabric3.api.binding.zeromq.model.ZeroMQMetadata;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.component.AbstractService;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.ReferenceDefinition;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.AbstractBindingPostProcessor;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class ZeroMQPostProcessor
extends AbstractBindingPostProcessor<ZeroMQ> {
    public ZeroMQPostProcessor() {
        super(ZeroMQ.class);
    }

    protected BindingDefinition processService(ZeroMQ annotation, AbstractService<?> boundService, InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        try {
            Class<?> serviceInterface = implClass.getClassLoader().loadClass(boundService.getServiceContract().getQualifiedInterfaceName());
            ZeroMQMetadata metadata = new ZeroMQMetadata();
            String bindingName = "ZMQ" + serviceInterface.getSimpleName();
            ZeroMQBindingDefinition binding = new ZeroMQBindingDefinition(bindingName, metadata);
            int port = annotation.port();
            if (port > 0) {
                SocketAddressDefinition address = new SocketAddressDefinition("localhost", port);
                metadata.setSocketAddresses(Collections.singletonList(address));
            } else {
                this.parseAddresses(annotation, metadata, implClass, implClass, context);
            }
            this.processMetadata(annotation, metadata);
            return binding;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected BindingDefinition processServiceCallback(ZeroMQ annotation, AbstractService<?> service, InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        return null;
    }

    protected BindingDefinition processReference(ZeroMQ annotation, ReferenceDefinition reference, AccessibleObject object, Class<?> implClass, IntrospectionContext context) {
        ZeroMQMetadata metadata = new ZeroMQMetadata();
        String bindingName = "ZMQ" + reference.getName();
        ZeroMQBindingDefinition binding = new ZeroMQBindingDefinition(bindingName, metadata);
        this.parseTarget(annotation, binding, object, implClass, context);
        this.parseAddresses(annotation, metadata, object, implClass, context);
        this.processMetadata(annotation, metadata);
        return binding;
    }

    protected BindingDefinition processReferenceCallback(ZeroMQ annotation, ReferenceDefinition reference, AccessibleObject object, Class<?> implClass, IntrospectionContext context) {
        return null;
    }

    private void processMetadata(ZeroMQ annotation, ZeroMQMetadata metadata) {
        metadata.setTimeout(annotation.timeout());
        metadata.setHighWater(annotation.highWater());
        metadata.setMulticastRate(annotation.multicastRate());
        metadata.setReceiveBuffer(annotation.receiveBuffer());
        metadata.setMulticastRecovery(annotation.multicastRecovery());
        metadata.setSendBuffer(annotation.sendBuffer());
        metadata.setWireFormat(annotation.wireFormat());
    }

    private void parseAddresses(ZeroMQ annotation, ZeroMQMetadata metadata, AnnotatedElement element, Class<?> implClass, IntrospectionContext context) {
        String[] addressStrings;
        String addresses = annotation.addresses();
        if (addresses.length() == 0) {
            return;
        }
        ArrayList<SocketAddressDefinition> addressDefinitions = new ArrayList<SocketAddressDefinition>();
        for (String entry : addressStrings = addresses.split("\\s+")) {
            String[] tokens = entry.split(":");
            if (tokens.length != 2) {
                context.addError((ValidationFailure)new InvalidAnnotation("Invalid address specified on ZeroMQ binding: " + entry, element, (Annotation)annotation, implClass));
                continue;
            }
            try {
                String host = tokens[0];
                int port = Integer.parseInt(tokens[1]);
                addressDefinitions.add(new SocketAddressDefinition(host, port));
            }
            catch (NumberFormatException e) {
                context.addError((ValidationFailure)new InvalidAnnotation("Invalid port specified on ZeroMQ binding: " + e.getMessage(), element, (Annotation)annotation, implClass));
            }
        }
        metadata.setSocketAddresses(addressDefinitions);
    }

    private void parseTarget(ZeroMQ annotation, ZeroMQBindingDefinition binding, AccessibleObject object, Class<?> implClass, IntrospectionContext context) {
        String target = annotation.target();
        try {
            URI targetUri = new URI(target);
            binding.setTargetUri(targetUri);
        }
        catch (URISyntaxException e) {
            InvalidAnnotation error = new InvalidAnnotation("Invalid target URI specified on ZeroMQ annotation: " + target, (AnnotatedElement)object, (Annotation)annotation, implClass, (Exception)e);
            context.addError((ValidationFailure)error);
        }
    }
}

