/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.introspection;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.binding.zeromq.model.SocketAddressDefinition;
import org.fabric3.api.binding.zeromq.model.ZeroMQBindingDefinition;
import org.fabric3.api.binding.zeromq.model.ZeroMQMetadata;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ZeroMQBindingLoader
extends AbstractValidatingTypeLoader<ZeroMQBindingDefinition> {
    private final LoaderHelper loaderHelper;

    public ZeroMQBindingLoader(@Reference LoaderHelper loaderHelper) {
        this.loaderHelper = loaderHelper;
        this.addAttributes(new String[]{"name", "requires", "policySets", "timeout", "target", "addresses", "name", "high.water", "multicast.rate", "multicast.recovery", "send.buffer", "receive.buffer", "wireFormat"});
    }

    public ZeroMQBindingDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        String timeoutStr;
        Location startLocation = reader.getLocation();
        String bindingName = reader.getAttributeValue(null, "name");
        ZeroMQMetadata metadata = new ZeroMQMetadata();
        ZeroMQBindingDefinition definition = new ZeroMQBindingDefinition(bindingName, metadata);
        String target = reader.getAttributeValue(null, "target");
        if (target != null) {
            try {
                URI targetUri = new URI(target);
                definition.setTargetUri(targetUri);
            }
            catch (URISyntaxException e) {
                InvalidValue error = new InvalidValue("Invalid target URI specified: " + target, startLocation, (Throwable)e, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
        if ((timeoutStr = reader.getAttributeValue(null, "timeout")) != null) {
            try {
                long timeout = Long.parseLong(timeoutStr);
                metadata.setTimeout(timeout);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid timeout specified: " + timeoutStr, startLocation, (Throwable)e, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
        String addresses = reader.getAttributeValue(null, "addresses");
        long highWater = this.parseLong("high.water", reader, context);
        long multicastRate = this.parseLong("multicast.rate", reader, context);
        long multicastRecovery = this.parseLong("multicast.recovery", reader, context);
        long sendBuffer = this.parseLong("send.buffer", reader, context);
        long receiveBuffer = this.parseLong("receive.buffer", reader, context);
        String wireFormat = reader.getAttributeValue(null, "wireFormat");
        if (addresses != null) {
            String[] addressStrings;
            ArrayList<SocketAddressDefinition> addressDefinitions = new ArrayList<SocketAddressDefinition>();
            for (String entry : addressStrings = addresses.split("\\s+")) {
                String[] tokens = entry.split(":");
                if (tokens.length != 2) {
                    context.addError((ValidationFailure)new InvalidValue("Invalid address: " + entry, startLocation, new ModelObject[]{definition}));
                    continue;
                }
                try {
                    String host = tokens[0];
                    int port = Integer.parseInt(tokens[1]);
                    addressDefinitions.add(new SocketAddressDefinition(host, port));
                }
                catch (NumberFormatException e) {
                    context.addError((ValidationFailure)new InvalidValue("Invalid port: " + e.getMessage(), startLocation, new ModelObject[]{definition}));
                }
            }
            metadata.setSocketAddresses(addressDefinitions);
        }
        metadata.setHighWater(highWater);
        metadata.setMulticastRate(multicastRate);
        metadata.setMulticastRecovery(multicastRecovery);
        metadata.setSendBuffer(sendBuffer);
        metadata.setReceiveBuffer(receiveBuffer);
        metadata.setWireFormat(wireFormat);
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)definition, reader, context);
        this.validateAttributes(reader, context, new ModelObject[]{definition});
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        return definition;
    }

    private long parseLong(String name, XMLStreamReader reader, IntrospectionContext context) {
        try {
            String val = reader.getAttributeValue(null, name);
            if (val == null) {
                return -1L;
            }
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            Location location = reader.getLocation();
            InvalidValue error = new InvalidValue("Invalid value specified for " + name, location, (Throwable)e, new ModelObject[0]);
            context.addError((ValidationFailure)error);
            return -1L;
        }
    }
}

