/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.generator;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.binding.zeromq.model.ZeroMQBindingDefinition;
import org.fabric3.api.binding.zeromq.model.ZeroMQMetadata;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.binding.zeromq.generator.InvalidContractException;
import org.fabric3.binding.zeromq.provision.ZeroMQWireSourceDefinition;
import org.fabric3.binding.zeromq.provision.ZeroMQWireTargetDefinition;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.policy.EffectivePolicy;
import org.fabric3.spi.domain.generator.wire.WireBindingGenerator;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class ZeroMQWireBindingGenerator
implements WireBindingGenerator<ZeroMQBindingDefinition> {
    private static final QName ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "oneWay");
    private static final String TARGET_URI = "targetUri";

    public ZeroMQWireSourceDefinition generateSource(LogicalBinding<ZeroMQBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        ZeroMQMetadata metadata = ((ZeroMQBindingDefinition)binding.getDefinition()).getZeroMQMetadata();
        if (binding.isCallback()) {
            URI uri = URI.create("zmq://" + contract.getInterfaceName());
            return new ZeroMQWireSourceDefinition(uri, metadata);
        }
        return new ZeroMQWireSourceDefinition(metadata);
    }

    public ZeroMQWireTargetDefinition generateTarget(LogicalBinding<ZeroMQBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        URI targetUri;
        this.validateServiceContract(contract);
        ZeroMQMetadata metadata = ((ZeroMQBindingDefinition)binding.getDefinition()).getZeroMQMetadata();
        if (binding.isCallback()) {
            URI targetUri2 = URI.create("zmq://" + contract.getInterfaceName());
            return new ZeroMQWireTargetDefinition(targetUri2, metadata);
        }
        if (LogicalState.MARKED == binding.getState()) {
            targetUri = (URI)binding.getMetadata(TARGET_URI, URI.class);
        } else {
            targetUri = this.parseTargetUri(binding);
            if (targetUri != null) {
                binding.addMetadata(TARGET_URI, (Object)targetUri);
            }
        }
        return this.generateTarget(contract, targetUri, metadata);
    }

    public ZeroMQWireTargetDefinition generateServiceBindingTarget(LogicalBinding<ZeroMQBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        URI targetUri = ((Bindable)binding.getParent()).getUri();
        ZeroMQMetadata metadata = ((ZeroMQBindingDefinition)binding.getDefinition()).getZeroMQMetadata();
        return this.generateTarget(contract, targetUri, metadata);
    }

    private ZeroMQWireTargetDefinition generateTarget(ServiceContract contract, URI targetUri, ZeroMQMetadata metadata) {
        boolean hasCallback;
        boolean bl = hasCallback = contract.getCallbackContract() != null;
        if (hasCallback) {
            URI callbackUri = URI.create("zmq://" + contract.getCallbackContract().getInterfaceName());
            return new ZeroMQWireTargetDefinition(targetUri, callbackUri, metadata);
        }
        return new ZeroMQWireTargetDefinition(targetUri, metadata);
    }

    private URI parseTargetUri(LogicalBinding<ZeroMQBindingDefinition> binding) throws GenerationException {
        URI targetUri;
        URI bindingTargetUri = ((ZeroMQBindingDefinition)binding.getDefinition()).getTargetUri();
        if (bindingTargetUri == null) {
            return URI.create("f3synthetic://" + ((Bindable)binding.getParent()).getUri() + "/" + ((ZeroMQBindingDefinition)binding.getDefinition()).getName());
        }
        LogicalCompositeComponent composite = (LogicalCompositeComponent)((LogicalComponent)((Bindable)binding.getParent()).getParent()).getParent();
        URI parent = composite.getUri();
        String bindingTarget = bindingTargetUri.toString();
        if (bindingTarget.contains("/")) {
            String[] tokens = bindingTarget.split("/");
            if (tokens.length != 2) {
                throw new GenerationException("Invalid target specified on binding: " + bindingTarget);
            }
            targetUri = URI.create(parent.toString() + "/" + tokens[0]);
            LogicalComponent component = composite.getComponent(targetUri);
            if (component == null) {
                throw new GenerationException("Target component not found: " + targetUri);
            }
            LogicalService service = component.getService(tokens[1]);
            if (service == null) {
                throw new GenerationException("Target service not found on component " + targetUri + ": " + tokens[1]);
            }
            targetUri = service.getLeafService().getUri();
        } else {
            targetUri = URI.create(parent.toString() + "/" + bindingTarget);
            if (targetUri.getFragment() == null) {
                LogicalComponent component = composite.getComponent(targetUri);
                if (component == null) {
                    throw new GenerationException("Target component not found: " + targetUri);
                }
                if (component.getServices().size() != 1) {
                    throw new GenerationException("Target component must have exactly one service if the service is not specified in the target URI");
                }
                Collection services = component.getServices();
                LogicalService service = (LogicalService)services.iterator().next();
                targetUri = service.getLeafService().getUri();
            } else {
                URI defragmented = UriHelper.getDefragmentedName((URI)targetUri);
                LogicalComponent component = composite.getComponent(defragmented);
                if (component == null) {
                    throw new GenerationException("Target component not found: " + targetUri);
                }
            }
        }
        return targetUri;
    }

    private void validateServiceContract(ServiceContract contract) throws InvalidContractException {
        boolean oneway = false;
        boolean first = true;
        for (Operation operation : contract.getOperations()) {
            if (first) {
                oneway = operation.getIntents().contains(ONEWAY);
                first = false;
                continue;
            }
            boolean oneWayIntent = operation.getIntents().contains(ONEWAY);
            if ((oneway || !oneWayIntent) && (!oneway || oneWayIntent)) continue;
            String name = contract.getInterfaceName();
            throw new InvalidContractException("The ZeroMQ binding does not support mixing one-way and request-response operations: " + name);
        }
    }
}

