/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.zeromq.generator;

import java.net.URI;
import org.fabric3.api.binding.zeromq.model.ZeroMQBindingDefinition;
import org.fabric3.api.binding.zeromq.model.ZeroMQMetadata;
import org.fabric3.binding.zeromq.provision.ZeroMQChannelBindingDefinition;
import org.fabric3.binding.zeromq.provision.ZeroMQConnectionSourceDefinition;
import org.fabric3.binding.zeromq.provision.ZeroMQConnectionTargetDefinition;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.channel.ConnectionBindingGenerator;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.physical.ChannelDeliveryType;
import org.fabric3.spi.model.physical.PhysicalChannelBindingDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class ZeroMQConnectionBindingGenerator
implements ConnectionBindingGenerator<ZeroMQBindingDefinition> {
    public PhysicalConnectionSourceDefinition generateConnectionSource(LogicalConsumer consumer, LogicalBinding<ZeroMQBindingDefinition> binding, ChannelDeliveryType deliveryType) throws GenerationException {
        URI uri = consumer.getUri();
        ZeroMQMetadata metadata = ((ZeroMQBindingDefinition)binding.getDefinition()).getZeroMQMetadata();
        this.setChannelName(binding, metadata);
        return new ZeroMQConnectionSourceDefinition(uri, metadata);
    }

    public PhysicalConnectionTargetDefinition generateConnectionTarget(LogicalProducer producer, LogicalBinding<ZeroMQBindingDefinition> binding, ChannelDeliveryType deliveryType) throws GenerationException {
        ZeroMQBindingDefinition definition = (ZeroMQBindingDefinition)binding.getDefinition();
        URI targetUri = definition.getTargetUri();
        if (targetUri == null) {
            targetUri = ((Bindable)binding.getParent()).getUri();
        }
        ZeroMQMetadata metadata = definition.getZeroMQMetadata();
        this.setChannelName(binding, metadata);
        boolean dedicatedThread = ChannelDeliveryType.ASYNCHRONOUS_WORKER == deliveryType;
        return new ZeroMQConnectionTargetDefinition(targetUri, metadata, dedicatedThread);
    }

    public PhysicalChannelBindingDefinition generateChannelBinding(LogicalBinding<ZeroMQBindingDefinition> binding, ChannelDeliveryType deliveryType) throws GenerationException {
        return new ZeroMQChannelBindingDefinition(deliveryType);
    }

    private void setChannelName(LogicalBinding binding, ZeroMQMetadata metadata) {
        if (binding.getParent() instanceof LogicalChannel) {
            String channelName = ((LogicalChannel)binding.getParent()).getDefinition().getName();
            metadata.setChannelName(channelName);
        }
    }
}

