/*
 * Fabric3
 * Copyright (c) 2009-2015 Metaform Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.fabric3.binding.zeromq.builder;

import org.fabric3.binding.zeromq.provision.ZeroMQChannelBindingDefinition;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.ChannelBindingBuilder;
import org.fabric3.spi.container.channel.Channel;

/**
 * A {@link ChannelBindingBuilder} that does nothing. Used to trigger creation of a channel that the ZeroMQ binding will connect to.
 */
public class ZeroMQChannelBindingBuilder implements ChannelBindingBuilder<ZeroMQChannelBindingDefinition>{

    public void build(ZeroMQChannelBindingDefinition definition, Channel channel) throws ContainerException {
        // no-op
    }

    public void dispose(ZeroMQChannelBindingDefinition definition, Channel channel) throws ContainerException {
        //no-op
    }
}
