/*
 * Decompiled with CFR 0.152.
 */
package org.everit.transaction.map.readcommited.internal;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class RWLockedMap<K, V>
implements Map<K, V> {
    protected final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected final Map<K, V> wrapped;

    public RWLockedMap(Map<K, V> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void clear() {
        this.doInLock(this.rwLock.writeLock(), () -> this.wrapped.clear());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.doInLock(this.rwLock.readLock(), () -> this.wrapped.containsKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.doInLock(this.rwLock.readLock(), () -> this.wrapped.containsValue(value));
    }

    protected void doInLock(Lock lock, Runnable action) {
        lock.lock();
        try {
            action.run();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R doInLock(Lock lock, Supplier<R> action) {
        lock.lock();
        try {
            R r = action.get();
            return r;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.doInLock(this.rwLock.readLock(), () -> this.wrapped.entrySet());
    }

    @Override
    public V get(Object key) {
        return (V)this.doInLock(this.rwLock.readLock(), () -> this.wrapped.get(key));
    }

    public ReadWriteLock getReadWriteLock() {
        return this.rwLock;
    }

    @Override
    public boolean isEmpty() {
        return this.doInLock(this.rwLock.readLock(), () -> this.wrapped.isEmpty());
    }

    @Override
    public Set<K> keySet() {
        return this.doInLock(this.rwLock.readLock(), () -> this.wrapped.keySet());
    }

    @Override
    public V put(K key, V value) {
        return (V)this.doInLock(this.rwLock.writeLock(), () -> this.wrapped.put(key, value));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.doInLock(this.rwLock.writeLock(), () -> this.wrapped.putAll(m));
    }

    @Override
    public V remove(Object key) {
        return (V)this.doInLock(this.rwLock.writeLock(), () -> this.wrapped.remove(key));
    }

    @Override
    public int size() {
        return this.doInLock(this.rwLock.readLock(), () -> this.wrapped.size());
    }

    @Override
    public Collection<V> values() {
        return this.doInLock(this.rwLock.readLock(), () -> this.wrapped.values());
    }
}

