/*
 * Decompiled with CFR 0.152.
 */
package org.everit.transaction.map.readcommited.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.everit.transaction.map.readcommited.internal.HashEntry;
import org.everit.transaction.map.readcommited.internal.RWLockedMap;

public class MapTxContext<K, V>
implements Map<K, V> {
    protected boolean cleared;
    protected Map<K, V> puts;
    protected boolean readOnly = true;
    protected Set<K> removes;
    protected final RWLockedMap<K, V> rwLockedMap;
    protected final Object transaction;

    public MapTxContext(RWLockedMap<K, V> rwLockedMap, Object transaction) {
        this.rwLockedMap = rwLockedMap;
        this.transaction = transaction;
        this.removes = new HashSet<K>();
        this.puts = new HashMap();
        this.cleared = false;
    }

    @Override
    public void clear() {
        this.readOnly = false;
        this.cleared = true;
        this.removes.clear();
        this.puts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (this.isReadOnly()) {
            return;
        }
        Lock writeLock = this.rwLockedMap.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            if (this.cleared) {
                this.rwLockedMap.clear();
            } else {
                for (K key : this.removes) {
                    this.rwLockedMap.remove(key);
                }
            }
            this.rwLockedMap.putAll(this.puts);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.puts.containsKey(key)) {
            return true;
        }
        if (this.cleared) {
            return false;
        }
        if (this.removes.contains(key)) {
            return false;
        }
        return this.rwLockedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet entrySet = new HashSet();
        MapTxContext avoidFindbugsThis = this;
        for (K key : this.keySet()) {
            Object value = avoidFindbugsThis.get(key);
            if (value == null) continue;
            entrySet.add(new HashEntry(key, value));
        }
        return Collections.unmodifiableSet(entrySet);
    }

    @Override
    public V get(Object key) {
        if (this.puts.containsKey(key)) {
            return this.puts.get(key);
        }
        if (this.cleared) {
            return null;
        }
        if (this.removes.contains(key)) {
            return null;
        }
        return this.rwLockedMap.get(key);
    }

    public Object getTransaction() {
        return this.transaction;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> keySet = new HashSet<K>();
        if (!this.cleared) {
            keySet.addAll(this.rwLockedMap.keySet());
            keySet.removeAll(this.removes);
        }
        keySet.addAll(this.puts.keySet());
        return Collections.unmodifiableSet(keySet);
    }

    @Override
    public V put(K key, V value) {
        this.readOnly = false;
        V oldValue = this.get(key);
        this.puts.put(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> name;
            Map.Entry<K, V> entry = name = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V oldValue = this.get(key);
        this.readOnly = false;
        this.puts.remove(key);
        if (!this.cleared) {
            Object typedKey = key;
            this.removes.add(typedKey);
        }
        return oldValue;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        Set<K> keys = this.keySet();
        MapTxContext avoidFindbugsThis = this;
        for (K key : keys) {
            Object value = avoidFindbugsThis.get(key);
            if (value == null) continue;
            values.add(value);
        }
        return Collections.unmodifiableCollection(values);
    }
}

