/*
 * Decompiled with CFR 0.152.
 */
package org.everit.transaction.map.readcommited;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.everit.transaction.map.TransactionalMap;
import org.everit.transaction.map.readcommited.internal.MapTxContext;
import org.everit.transaction.map.readcommited.internal.RWLockedMap;

public class ReadCommitedTransactionalMap<K, V>
implements TransactionalMap<K, V> {
    protected ThreadLocal<MapTxContext<K, V>> activeTx = new ThreadLocal();
    protected final Map<Object, MapTxContext<K, V>> suspendedTXContexts = new ConcurrentHashMap<Object, MapTxContext<K, V>>();
    protected final RWLockedMap<K, V> wrapped;

    public ReadCommitedTransactionalMap(Map<K, V> wrapped) {
        this.wrapped = wrapped != null ? new RWLockedMap<K, V>(wrapped) : new RWLockedMap(new HashMap());
    }

    public void clear() {
        this.coalesceActiveTxOrWrapped().clear();
    }

    protected Map<K, V> coalesceActiveTxOrWrapped() {
        MapTxContext<K, V> txContext = this.getActiveTx();
        return txContext != null ? txContext : this.wrapped;
    }

    public void commitTransaction() {
        MapTxContext<K, V> mapTXContext = this.getActiveTx();
        if (mapTXContext == null) {
            throw new IllegalStateException("There is no active transaction to commit");
        }
        mapTXContext.commit();
        this.setActiveTx(null);
    }

    public boolean containsKey(Object key) {
        return this.coalesceActiveTxOrWrapped().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.coalesceActiveTxOrWrapped().containsValue(value);
    }

    protected MapTxContext<K, V> createMapTxContext(Object transaction) {
        return new MapTxContext<K, V>(this.wrapped, transaction);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.coalesceActiveTxOrWrapped().entrySet();
    }

    public V get(Object key) {
        return this.coalesceActiveTxOrWrapped().get(key);
    }

    protected MapTxContext<K, V> getActiveTx() {
        return this.activeTx.get();
    }

    public Object getAssociatedTransaction() {
        MapTxContext<K, V> txContext = this.getActiveTx();
        if (txContext == null) {
            return null;
        }
        return txContext.getTransaction();
    }

    public boolean isEmpty() {
        return this.coalesceActiveTxOrWrapped().isEmpty();
    }

    public Set<K> keySet() {
        return this.coalesceActiveTxOrWrapped().keySet();
    }

    public V put(K key, V value) {
        return this.coalesceActiveTxOrWrapped().put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.coalesceActiveTxOrWrapped().putAll(m);
    }

    public V remove(Object key) {
        return this.coalesceActiveTxOrWrapped().remove(key);
    }

    public void resumeTransaction(Object transaction) {
        Objects.requireNonNull(transaction);
        if (this.getActiveTx() != null) {
            throw new IllegalStateException("Cannot resume transaction when there is another active associated transaction");
        }
        MapTxContext<K, V> txContext = this.suspendedTXContexts.remove(transaction);
        if (txContext == null) {
            throw new IllegalStateException("There is no such suspended associated transaction");
        }
        this.setActiveTx(txContext);
    }

    public void rollbackTransaction() {
        if (this.getActiveTx() == null) {
            throw new IllegalStateException("No active associated transaction to rollback.");
        }
        this.setActiveTx(null);
    }

    protected void setActiveTx(MapTxContext<K, V> mapContext) {
        this.activeTx.set(mapContext);
    }

    public int size() {
        return this.coalesceActiveTxOrWrapped().size();
    }

    public void startTransaction(Object transaction) {
        if (this.getActiveTx() != null) {
            throw new IllegalStateException("Cannot start new transaction when there is an associated active transaction");
        }
        if (this.suspendedTXContexts.containsKey(transaction)) {
            throw new IllegalStateException("Transaction is already associated to Map in suspended state");
        }
        this.setActiveTx(this.createMapTxContext(transaction));
    }

    public void suspendTransaction() {
        MapTxContext<K, V> activeTx = this.getActiveTx();
        if (activeTx == null) {
            throw new IllegalStateException("There is no active associated transaction to suspend");
        }
        this.suspendedTXContexts.put(activeTx.getTransaction(), activeTx);
        this.setActiveTx(null);
    }

    public Collection<V> values() {
        return this.coalesceActiveTxOrWrapped().values();
    }
}

