/*
 * Decompiled with CFR 0.152.
 */
package org.everit.persistence.lqmg.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.everit.persistence.lqmg.GenerationProperties;
import org.everit.persistence.lqmg.LQMG;

@Mojo(name="generate", requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(required=true, property="lqmg.capability")
    private String capability;
    @Parameter(required=false, property="lqmg.configFile")
    private String configFile;
    @Parameter(required=false, property="lqmg.contexts")
    private String contexts;
    @Parameter(property="lqmg.defaultSchema", defaultValue="${project.artifactId}")
    private String defaultSchema;
    @Parameter(property="lqmg.hackWires", defaultValue="true")
    private boolean hackWires;
    @Parameter(property="lqmg.innerClassesForKeys", defaultValue="true")
    private boolean innerClassesForKeys;
    @Parameter(required=true, property="lqmg.outputFolder", defaultValue="src/main/generated/java")
    private String outputFolder;
    @Parameter(required=false, property="lqmg.packages")
    private String packages;
    @Parameter(defaultValue="${plugin.artifactMap}", required=true, readonly=true)
    protected Map<String, Artifact> pluginArtifactMap;
    @Parameter(property="executedProject")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Start lqmg-maven-plugin.");
        GenerationProperties params = null;
        File targetFolderFile = new File(this.outputFolder);
        String generationFolder = new File(this.project.getBasedir().getAbsolutePath(), this.outputFolder).getAbsolutePath();
        if (targetFolderFile.isAbsolute()) {
            generationFolder = new File(this.outputFolder).getAbsolutePath();
        }
        this.getLog().info((CharSequence)("Generation target folder: " + generationFolder));
        String[] projectArtifactsPath = this.getProjectArtifactsPath();
        params = new GenerationProperties(this.capability, projectArtifactsPath, generationFolder);
        params.setConfigurationPath(this.configFile);
        params.setDefaultSchema(this.defaultSchema);
        params.setHackWires(this.hackWires);
        params.setInnerClassesForKeys(this.innerClassesForKeys);
        params.setContexts(this.contexts);
        if (this.packages != null && !"".equals(this.packages.trim())) {
            params.setPackages(this.packages.split(","));
        }
        LQMG.generate((GenerationProperties)params);
        this.getLog().info((CharSequence)("Finished the metamodell generation at path " + generationFolder));
    }

    private String[] getProjectArtifactsPath() throws MojoExecutionException {
        HashSet<String> artifactsPath = new HashSet<String>();
        Set dependencyArtifacts = this.project.getArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            String artifactFileURI = this.resolveArtifactFileURI(artifact);
            if (artifactFileURI == null) continue;
            this.getLog().info((CharSequence)("Adding artifact: " + artifactFileURI));
            artifactsPath.add(artifactFileURI);
        }
        Artifact projectArtifact = this.project.getArtifact();
        String projectArtifactURI = this.resolveArtifactFileURI(projectArtifact);
        if (projectArtifactURI != null) {
            this.getLog().info((CharSequence)("Adding artifact (current project): " + projectArtifactURI));
            artifactsPath.add(projectArtifactURI);
        } else {
            String buildDirectoryString = this.project.getBuild().getOutputDirectory();
            File buildDirectory = new File(buildDirectoryString);
            if (buildDirectory.exists()) {
                try {
                    String buildDirectoryURI = buildDirectory.toURI().toURL().toExternalForm();
                    this.getLog().info((CharSequence)("Adding build directory of current project: " + buildDirectoryURI));
                    artifactsPath.add(buildDirectoryURI);
                }
                catch (MalformedURLException e) {
                    this.getLog().error((Throwable)e);
                }
            } else {
                this.getLog().warn((CharSequence)"Current project could not be added as a bundle. Please check if this is ok.");
            }
        }
        return artifactsPath.toArray(new String[artifactsPath.size()]);
    }

    private String resolveArtifactFileURI(Artifact artifact) {
        File artifactFile = artifact.getFile();
        if (artifactFile != null) {
            try {
                return artifact.getFile().toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException e) {
                this.getLog().error((Throwable)e);
            }
        }
        return null;
    }
}

