/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.org.everit.osgi.webconsole.threadviewer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.everit.expression.ExpressionCompiler;
import org.everit.expression.ParserConfiguration;
import org.everit.expression.mvel.MvelExpressionCompiler;
import org.everit.templating.CompiledTemplate;
import org.everit.templating.html.HTMLTemplateCompiler;
import org.everit.templating.text.TextTemplateCompiler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.metatype.MetaTypeProvider;

public class ThreadViewerServlet
implements Servlet {
    private static final String FRAGMENT_CONTENT = "content";
    private static final int HTTP_NOT_FOUND = 404;
    private static final ThreadComparator THREAD_COMPARATOR = new ThreadComparator();
    private final ClassLoader classLoader;
    private final CompiledTemplate componentsTemplate;
    private ServletConfig config;

    public ThreadViewerServlet(BundleContext bundleContext) {
        this.classLoader = ((BundleWiring)bundleContext.getBundle().adapt(BundleWiring.class)).getClassLoader();
        MvelExpressionCompiler expressionCompiler = new MvelExpressionCompiler();
        TextTemplateCompiler textTemplateCompiler = new TextTemplateCompiler((ExpressionCompiler)expressionCompiler);
        HashMap<String, TextTemplateCompiler> inlineCompilers = new HashMap<String, TextTemplateCompiler>();
        inlineCompilers.put("text", textTemplateCompiler);
        HTMLTemplateCompiler htmlTemplateCompiler = new HTMLTemplateCompiler((ExpressionCompiler)expressionCompiler, inlineCompilers);
        ParserConfiguration parserConfiguration = new ParserConfiguration(this.classLoader);
        HashMap<String, Class<MetaTypeProvider>> variableTypes = new HashMap<String, Class<MetaTypeProvider>>();
        variableTypes.put("mp", MetaTypeProvider.class);
        parserConfiguration.setVariableTypes(variableTypes);
        this.componentsTemplate = htmlTemplateCompiler.compile(this.readResource("META-INF/webcontent/threadviewer.html"), parserConfiguration);
    }

    public void destroy() {
    }

    private Thread findThreadWithId(long threadId) {
        List<Thread> threads = this.getThreads();
        Thread result = null;
        Iterator<Thread> iterator = threads.iterator();
        while (iterator.hasNext() && result == null) {
            Thread thread = iterator.next();
            if (thread.getId() != threadId) continue;
            result = thread;
        }
        return result;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "ThreadViewer";
    }

    private List<Thread> getThreads() {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        ArrayList<Thread> threads = new ArrayList<Thread>(stackTraces.keySet());
        return threads;
    }

    public void init(ServletConfig pConfig) throws ServletException {
        this.config = pConfig;
    }

    private String readResource(String resourceName) {
        InputStream inputStream = this.classLoader.getResourceAsStream(resourceName);
        int bufferSize = 1024;
        byte[] buf = new byte[1024];
        try {
            int r = inputStream.read(buf);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while (r > -1) {
                bout.write(buf, 0, r);
                r = inputStream.read(buf);
            }
            return new String(bout.toByteArray(), Charset.forName("UTF8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        block7: {
            HttpServletRequest httpReq = (HttpServletRequest)req;
            HttpServletResponse httpResp = (HttpServletResponse)resp;
            httpResp.setContentType("text/html");
            PrintWriter writer = httpResp.getWriter();
            String appRoot = (String)httpReq.getAttribute("felix.webconsole.appRoot");
            String pluginRoot = (String)httpReq.getAttribute("felix.webconsole.pluginRoot");
            String requestURI = httpReq.getRequestURI();
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("appRoot", appRoot);
            vars.put("pluginRoot", pluginRoot);
            if (requestURI.equals(pluginRoot)) {
                List<Thread> threads = this.getThreads();
                Collections.sort(threads, THREAD_COMPARATOR);
                vars.put("threads", threads);
                this.componentsTemplate.render((Writer)writer, vars, FRAGMENT_CONTENT);
            } else if (requestURI.replace(pluginRoot + '/', "").length() > 0) {
                try {
                    long threadId = Long.parseLong(requestURI.replace(pluginRoot + "/", ""));
                    Thread thread = this.findThreadWithId(threadId);
                    if (thread != null) {
                        vars.put("thread", thread);
                        this.componentsTemplate.render((Writer)writer, vars, "threadDetails");
                        break block7;
                    }
                    httpResp.sendRedirect(pluginRoot);
                }
                catch (NumberFormatException e) {
                    httpResp.sendRedirect(pluginRoot);
                }
            } else {
                httpResp.setStatus(404);
                return;
            }
        }
    }

    private static final class ThreadComparator
    implements Comparator<Thread>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ThreadComparator() {
        }

        @Override
        public int compare(Thread o1, Thread o2) {
            return (int)(o1.getId() - o2.getId());
        }
    }
}

