/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.webconsole;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class TemplateUtil {
    private static final String CLAUSE_SEPARATOR = ";";

    private void appendStateToSBIfMatches(StringBuilder sb, int stateMask, int expectedState, String stateName) {
        if ((stateMask & expectedState) > 0) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(stateName);
        }
    }

    private String convertClauseToString(String namespace, Map<String, String> directives, Map<String, Object> attributes) {
        StringBuilder sb = new StringBuilder(namespace);
        if (directives.size() > 0) {
            sb.append(CLAUSE_SEPARATOR);
        }
        Map<String, Object> castedDirectives = directives;
        sb.append(this.translateClauseMap(castedDirectives, ":="));
        if (attributes.size() > 0) {
            sb.append(CLAUSE_SEPARATOR);
        }
        sb.append(this.translateClauseMap(attributes, "="));
        return sb.toString();
    }

    private String escapeClauseValue(String text) {
        if (text == null) {
            return "";
        }
        return text.replace(CLAUSE_SEPARATOR, "\\;").replace("\"", "\\\"").replace("\\", "\\\\");
    }

    public String toString(Object object) {
        if (object == null) {
            return "";
        }
        Class<?> objectType = object.getClass();
        if (objectType.isArray()) {
            StringBuilder sb = new StringBuilder("[");
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                Object entry;
                if (i > 0) {
                    sb.append(", ");
                }
                if ((entry = Array.get(object, i)) == null) continue;
                sb.append(this.toString(entry));
            }
            sb.append("]");
            return sb.toString();
        }
        if (object instanceof Capability) {
            Capability capability = (Capability)object;
            return this.convertClauseToString(capability.getNamespace(), capability.getDirectives(), capability.getAttributes());
        }
        if (object instanceof Requirement) {
            Requirement requirement = (Requirement)object;
            return this.convertClauseToString(requirement.getNamespace(), requirement.getDirectives(), requirement.getAttributes());
        }
        return String.valueOf(object);
    }

    public String translateClauseMap(Map<String, Object> clauseMap, String equalExpr) {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, Object>> clauseEntrySet = clauseMap.entrySet();
        boolean first = true;
        for (Map.Entry<String, Object> clauseEntry : clauseEntrySet) {
            if (!first) {
                sb.append(CLAUSE_SEPARATOR);
            }
            sb.append(clauseEntry.getKey()).append(equalExpr).append(this.escapeClauseValue(this.toString(clauseEntry.getValue())));
            first = false;
        }
        return sb.toString();
    }

    public String translateStateMask(int stateMask) {
        StringBuilder sb = new StringBuilder();
        this.appendStateToSBIfMatches(sb, stateMask, 4, "RESOLVED");
        this.appendStateToSBIfMatches(sb, stateMask, 8, "STARTING");
        this.appendStateToSBIfMatches(sb, stateMask, 32, "ACTIVE");
        this.appendStateToSBIfMatches(sb, stateMask, 16, "STOPPING");
        return sb.toString();
    }
}

