/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.webconsole;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.everit.expression.ExpressionCompiler;
import org.everit.expression.ParserConfiguration;
import org.everit.expression.mvel.MvelExpressionCompiler;
import org.everit.osgi.ecm.component.resource.ComponentContainer;
import org.everit.osgi.ecm.component.resource.ComponentRevision;
import org.everit.osgi.ecm.component.webconsole.ExceptionFormatter;
import org.everit.osgi.ecm.component.webconsole.TemplateUtil;
import org.everit.templating.CompiledTemplate;
import org.everit.templating.html.HTMLTemplateCompiler;
import org.everit.templating.text.TextTemplateCompiler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.util.tracker.ServiceTracker;

public class ECMWebConsoleServlet
implements Servlet {
    private static final ExceptionFormatter EXCEPTION_FORMATTER = new ExceptionFormatter();
    private static final String FRAGMENT_URI_SUFFIX = ".fragment";
    private static final int HTTP_NOT_FOUND = 404;
    private final BundleContext bundleContext;
    private final ClassLoader classLoader;
    private final CompiledTemplate componentsTemplate;
    private final ServiceTracker<ComponentContainer<?>, ComponentContainer<?>> containerTracker;
    private ServletConfig servletConfig;

    public ECMWebConsoleServlet(ServiceTracker<ComponentContainer<?>, ComponentContainer<?>> containerTracker, BundleContext bundleContext) {
        this.containerTracker = containerTracker;
        this.bundleContext = bundleContext;
        this.classLoader = ((BundleWiring)bundleContext.getBundle().adapt(BundleWiring.class)).getClassLoader();
        MvelExpressionCompiler expressionCompiler = new MvelExpressionCompiler();
        TextTemplateCompiler textTemplateCompiler = new TextTemplateCompiler((ExpressionCompiler)expressionCompiler);
        HashMap<String, TextTemplateCompiler> inlineCompilers = new HashMap<String, TextTemplateCompiler>();
        inlineCompilers.put("text", textTemplateCompiler);
        HTMLTemplateCompiler htmlTemplateCompiler = new HTMLTemplateCompiler((ExpressionCompiler)expressionCompiler, inlineCompilers);
        ParserConfiguration parserConfiguration = new ParserConfiguration(this.classLoader);
        HashMap<String, Class<MetaTypeProvider>> variableTypes = new HashMap<String, Class<MetaTypeProvider>>();
        variableTypes.put("mp", MetaTypeProvider.class);
        parserConfiguration.setVariableTypes(variableTypes);
        this.componentsTemplate = htmlTemplateCompiler.compile(this.readResource("META-INF/webcontent/ecm_components.html"), parserConfiguration);
    }

    private void addThreadViewerAvailablityToVars(Map<String, Object> vars) throws ServletException {
        boolean threadViewerAvailable = false;
        try {
            threadViewerAvailable = this.bundleContext.getServiceReferences(Servlet.class.getName(), "(felix.webconsole.label=threads)") != null;
        }
        catch (InvalidSyntaxException e) {
            throw new ServletException((Throwable)e);
        }
        vars.put("threadViewerAvailable", threadViewerAvailable);
    }

    public void destroy() {
    }

    private ComponentContainer<?> findContainerByServiceId(String serviceId) {
        Set entrySet = this.containerTracker.getTracked().entrySet();
        Iterator iterator = entrySet.iterator();
        ComponentContainer result = null;
        while (result == null && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ServiceReference serviceReference = (ServiceReference)entry.getKey();
            if (!serviceId.equals(String.valueOf(serviceReference.getProperty("service.id")))) continue;
            result = (ComponentContainer)entry.getValue();
        }
        return result;
    }

    private ComponentRevision<?> findRevision(ComponentRevision<?>[] revisions, String servicePid) {
        ComponentRevision<?> result = null;
        for (int i = 0; i < revisions.length && result == null; ++i) {
            ComponentRevision<?> componentRevision = revisions[i];
            if (!servicePid.equals(componentRevision.getProperties().get("service.pid"))) continue;
            result = componentRevision;
        }
        return result;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return "ECM Component Webconsole Plugin";
    }

    public void init(ServletConfig config) throws ServletException {
        this.servletConfig = config;
    }

    private String readResource(String resourceName) {
        InputStream inputStream = this.classLoader.getResourceAsStream(resourceName);
        int bufferSize = 1024;
        byte[] buf = new byte[1024];
        try {
            int r = inputStream.read(buf);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while (r > -1) {
                bout.write(buf, 0, r);
                r = inputStream.read(buf);
            }
            return new String(bout.toByteArray(), Charset.forName("UTF8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpResp = (HttpServletResponse)resp;
        httpResp.setContentType("text/html");
        PrintWriter writer = httpResp.getWriter();
        String appRoot = (String)httpReq.getAttribute("felix.webconsole.appRoot");
        String pluginRoot = (String)httpReq.getAttribute("felix.webconsole.pluginRoot");
        String requestURI = httpReq.getRequestURI();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("ccMap", this.containerTracker.getTracked());
        vars.put("appRoot", appRoot);
        vars.put("pluginRoot", pluginRoot);
        vars.put("templateUtil", new TemplateUtil());
        vars.put("exceptionFormatter", EXCEPTION_FORMATTER);
        if (requestURI.equals(pluginRoot)) {
            this.componentsTemplate.render((Writer)writer, vars, "content");
        } else if (requestURI.endsWith(FRAGMENT_URI_SUFFIX)) {
            this.addThreadViewerAvailablityToVars(vars);
            String serviceIdAndPid = requestURI.substring(pluginRoot.length() + 1, requestURI.length() - FRAGMENT_URI_SUFFIX.length());
            String[] split = serviceIdAndPid.split("\\/");
            ComponentContainer<?> container = this.findContainerByServiceId(split[0]);
            if (container == null) {
                httpResp.setStatus(404);
                return;
            }
            ComponentRevision[] revisions = container.getResources();
            ComponentRevision revision = null;
            if (split.length > 1) {
                revision = this.findRevision(revisions, split[1]);
            } else if (revisions.length == 1) {
                revision = revisions[0];
            }
            if (revision == null) {
                httpResp.setStatus(404);
                return;
            }
            vars.put("revision", revision);
            vars.put("container", container);
            this.componentsTemplate.render((Writer)writer, vars, "componentRevision");
        } else {
            httpResp.setStatus(404);
        }
    }
}

