/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal.resource;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.everit.osgi.capabilitycollector.RequirementDefinition;
import org.everit.osgi.capabilitycollector.Suiting;
import org.everit.osgi.ecm.component.resource.ComponentContainer;
import org.everit.osgi.ecm.component.resource.ComponentRequirement;
import org.everit.osgi.ecm.component.resource.ComponentRevision;
import org.everit.osgi.ecm.component.resource.ComponentState;
import org.everit.osgi.ecm.component.ri.internal.resource.ComponentRequirementImpl;
import org.everit.osgi.ecm.component.ri.internal.resource.ComponentWireImpl;
import org.everit.osgi.ecm.component.ri.internal.resource.ServiceCapabilityImpl;
import org.everit.osgi.ecm.metadata.BundleCapabilityReferenceMetadata;
import org.everit.osgi.ecm.metadata.ReferenceConfigurationType;
import org.everit.osgi.ecm.metadata.ReferenceMetadata;
import org.everit.osgi.ecm.metadata.ServiceReferenceMetadata;
import org.everit.osgi.linkage.ServiceCapability;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;

public class ComponentRevisionImpl<C>
implements ComponentRevision<C> {
    private static final ComponentRequirementComparator REQUIREMENT_COMPARATOR = new ComponentRequirementComparator();
    private final Map<String, List<Capability>> capabilitiesByNamespace;
    private final Throwable cause;
    private final ComponentContainer<C> container;
    private final BundleRevision declaringResource;
    private final Thread processingThread;
    private final Map<String, Object> properties;
    private final Map<String, List<Requirement>> requirementsByNamespace;
    private final ComponentState state;
    private final Map<Capability, List<Wire>> wiresByCapability;
    private final Map<Requirement, List<Wire>> wiresByRequirement;

    protected ComponentRevisionImpl(Builder<C> builder) {
        this.declaringResource = (BundleRevision)((Builder)builder).container.getBundleContext().getBundle().adapt(BundleRevision.class);
        this.state = ((Builder)builder).state;
        this.processingThread = ((Builder)builder).processingThread;
        this.cause = ((Builder)builder).cause;
        this.properties = ((Builder)builder).properties;
        this.container = ((Builder)builder).container;
        this.capabilitiesByNamespace = this.evaluateCapabilities(builder);
        RequirementsAndWires requirementsAndWires = this.evaluateRequirementsAndWires(builder);
        for (Map.Entry<String, List<Requirement>> entry : requirementsAndWires.requirements.entrySet()) {
            Collections.sort(entry.getValue(), REQUIREMENT_COMPARATOR);
            entry.setValue(Collections.unmodifiableList(entry.getValue()));
        }
        this.requirementsByNamespace = Collections.unmodifiableMap(requirementsAndWires.requirements);
        HashMap lWiresByCapability = new HashMap();
        HashMap lWiresByRequirement = new HashMap();
        List<Wire> wires = requirementsAndWires.wires;
        for (Wire wire : wires) {
            Capability capability = wire.getCapability();
            Requirement requirement = wire.getRequirement();
            this.addToWireMap(lWiresByCapability, capability, wire);
            this.addToWireMap(lWiresByRequirement, requirement, wire);
        }
        this.wiresByCapability = this.convertToUnmodifiableWireMap(lWiresByCapability);
        this.wiresByRequirement = this.convertToUnmodifiableWireMap(lWiresByRequirement);
    }

    private void addFilterToRequirementDefinitionIfExists(Map<String, String> directives, RequirementDefinition<?> requirementDefinition) {
        if (requirementDefinition.getFilter() != null) {
            directives.put("filter", requirementDefinition.getFilter().toString());
        }
    }

    private <CONNECTOR> void addToWireMap(Map<CONNECTOR, List<Wire>> map, CONNECTOR connector, Wire wire) {
        List<Wire> wireList = map.get(connector);
        if (wireList == null) {
            wireList = new ArrayList<Wire>();
            map.put(connector, wireList);
        }
        wireList.add(wire);
    }

    private <CONNECTOR> Map<CONNECTOR, List<Wire>> convertToUnmodifiableWireMap(Map<CONNECTOR, List<Wire>> map) {
        Set<Map.Entry<CONNECTOR, List<Wire>>> entrySet = map.entrySet();
        for (Map.Entry<CONNECTOR, List<Wire>> entry : entrySet) {
            entry.setValue(Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    private String createFullRequirementId(ReferenceMetadata referenceMetadata, String referenceId, Suiting<?> suiting) {
        String fullRequirementId = referenceId;
        if (referenceMetadata.isMultiple() || referenceMetadata.getReferenceConfigurationType() == ReferenceConfigurationType.CLAUSE) {
            fullRequirementId = fullRequirementId + "[" + suiting.getRequirement().getRequirementId() + "]";
        }
        return fullRequirementId;
    }

    private Map<String, List<Capability>> evaluateCapabilities(Builder<C> builder) {
        if (this.state != ComponentState.ACTIVE && this.state != ComponentState.UNSATISFIED && this.state != ComponentState.FAILED || ((Builder)builder).serviceRegistrations.size() == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        ArrayList<ServiceCapabilityImpl> serviceCapabilityList = new ArrayList<ServiceCapabilityImpl>(((Builder)builder).serviceRegistrations.size());
        for (ServiceRegistration serviceRegistration : ((Builder)builder).serviceRegistrations) {
            serviceCapabilityList.add(new ServiceCapabilityImpl(serviceRegistration.getReference()));
        }
        result.put("osgi.service", Collections.unmodifiableList(serviceCapabilityList));
        return Collections.unmodifiableMap(result);
    }

    private RequirementsAndWires evaluateRequirementsAndWires(Builder<C> builder) {
        if (this.state != ComponentState.ACTIVE && this.state != ComponentState.UNSATISFIED && this.state != ComponentState.FAILED) {
            return new RequirementsAndWires();
        }
        Set suitingEntries = ((Builder)builder).suitingsByAttributeIds.entrySet();
        Iterator suitingEntryIterator = suitingEntries.iterator();
        RequirementsAndWires result = new RequirementsAndWires();
        while (suitingEntryIterator.hasNext()) {
            Suiting[] suitings;
            Map.Entry entry = suitingEntryIterator.next();
            ReferenceMetadata referenceMetadata = (ReferenceMetadata)entry.getKey();
            String referenceId = referenceMetadata.getReferenceId();
            String namespace = this.resolveNamespaceForWire(referenceMetadata);
            List<Requirement> requirementsOfNS = this.getOrCreateRequirementListOfNS(result, namespace);
            for (Suiting suiting : suitings = (Suiting[])entry.getValue()) {
                Class<Capability> capabilityType;
                String serviceInterface;
                String fullRequirementId = this.createFullRequirementId(referenceMetadata, referenceId, suiting);
                LinkedHashMap<String, String> directives = new LinkedHashMap<String, String>();
                RequirementDefinition requirementDefinition = suiting.getRequirement();
                if (referenceMetadata instanceof ServiceReferenceMetadata && (serviceInterface = ((ServiceReferenceMetadata)referenceMetadata).getServiceInterface()) != null) {
                    directives.put("objectClass", serviceInterface);
                }
                this.addFilterToRequirementDefinitionIfExists(directives, requirementDefinition);
                Class<Capability> simpleCapabilityType = capabilityType = this.specifyCapabilityType(referenceMetadata);
                LinkedHashMap attributes = new LinkedHashMap(requirementDefinition.getAttributes());
                ComponentRequirementImpl requirement = new ComponentRequirementImpl(fullRequirementId, namespace, this, Collections.unmodifiableMap(directives), Collections.unmodifiableMap(attributes), simpleCapabilityType);
                requirementsOfNS.add((Requirement)requirement);
                Object capabilityObject = suiting.getCapability();
                Object capability = null;
                if (capabilityObject == null) continue;
                capability = capabilityObject instanceof ServiceReference ? new ServiceCapabilityImpl((ServiceReference)capabilityObject) : (BundleCapability)capabilityObject;
                result.wires.add((Wire)new ComponentWireImpl((Requirement)requirement, (Capability)capability));
            }
        }
        return result;
    }

    public List<Capability> getCapabilities(String namespace) {
        return this.getConnectorsByNamespace(namespace, this.capabilitiesByNamespace);
    }

    public Throwable getCause() {
        return this.cause;
    }

    public ComponentContainer<C> getComponentContainer() {
        return this.container;
    }

    private <W> List<W> getConnectorsByNamespace(String namespace, Map<String, List<W>> wiringsByNamespace) {
        List<Object> result;
        if (namespace != null) {
            result = wiringsByNamespace.get(namespace);
            if (result == null) {
                result = Collections.emptyList();
            }
        } else {
            result = new ArrayList();
            Collection<List<W>> values = wiringsByNamespace.values();
            for (List<W> requirements : values) {
                result.addAll(requirements);
            }
            result = Collections.unmodifiableList(result);
        }
        return result;
    }

    public BundleRevision getDeclaringResource() {
        return this.declaringResource;
    }

    private List<Requirement> getOrCreateRequirementListOfNS(RequirementsAndWires result, String namespace) {
        List<Requirement> requirementsOfNS = result.requirements.get(namespace);
        if (requirementsOfNS == null) {
            requirementsOfNS = new ArrayList<Requirement>();
            result.requirements.put(namespace, requirementsOfNS);
        }
        return requirementsOfNS;
    }

    public Thread getProcessingThread() {
        return this.processingThread;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public List<Requirement> getRequirements(String namespace) {
        return this.getConnectorsByNamespace(namespace, this.requirementsByNamespace);
    }

    public ComponentState getState() {
        return this.state;
    }

    public List<Wire> getWires() {
        Set<Map.Entry<Capability, List<Wire>>> entrySet = this.wiresByCapability.entrySet();
        if (entrySet.size() == 0) {
            return Collections.emptyList();
        }
        Iterator<Map.Entry<Capability, List<Wire>>> iterator = entrySet.iterator();
        if (entrySet.size() == 1) {
            return iterator.next().getValue();
        }
        ArrayList<Wire> result = new ArrayList<Wire>();
        while (iterator.hasNext()) {
            Map.Entry<Capability, List<Wire>> entry = iterator.next();
            result.addAll((Collection<Wire>)entry.getValue());
        }
        return result;
    }

    public List<Wire> getWiresByCapability(Capability capability) {
        List<Wire> wireList = this.wiresByCapability.get(capability);
        if (wireList == null) {
            return Collections.emptyList();
        }
        return wireList;
    }

    public List<Wire> getWiresByRequirement(Requirement requirement) {
        List<Wire> wireList = this.wiresByRequirement.get(requirement);
        if (wireList == null) {
            return Collections.emptyList();
        }
        return wireList;
    }

    private String resolveNamespaceForWire(ReferenceMetadata referenceMetadata) {
        String namespace = "osgi.service";
        if (referenceMetadata instanceof BundleCapabilityReferenceMetadata) {
            namespace = ((BundleCapabilityReferenceMetadata)referenceMetadata).getNamespace();
        }
        return namespace;
    }

    private Class<? extends Capability> specifyCapabilityType(ReferenceMetadata referenceMetadata) {
        Class capabilityType = referenceMetadata instanceof ServiceReferenceMetadata ? ServiceCapability.class : BundleCapability.class;
        return capabilityType;
    }

    private static class RequirementsAndWires {
        public Map<String, List<Requirement>> requirements = new HashMap<String, List<Requirement>>();
        public List<Wire> wires = new ArrayList<Wire>();

        private RequirementsAndWires() {
        }
    }

    private static final class ComponentRequirementComparator
    implements Comparator<Requirement>,
    Serializable {
        private static final long serialVersionUID = 6122207464125210506L;

        private ComponentRequirementComparator() {
        }

        @Override
        public int compare(Requirement o1, Requirement o2) {
            return ((ComponentRequirement)o1).getRequirementId().compareTo(((ComponentRequirement)o2).getRequirementId());
        }
    }

    public static class Builder<C> {
        private SoftReference<ComponentRevisionImpl<C>> cache = null;
        private Throwable cause = null;
        private final ComponentContainer<C> container;
        private Thread processingThread = null;
        private Map<String, Object> properties;
        private final LinkedHashSet<ServiceRegistration<?>> serviceRegistrations = new LinkedHashSet();
        private ComponentState state = ComponentState.INACTIVE;
        private final Map<ReferenceMetadata, Suiting<?>[]> suitingsByAttributeIds = new HashMap<ReferenceMetadata, Suiting<?>[]>();

        public Builder(ComponentContainer<C> container, Map<String, Object> properties) {
            this.container = container;
            this.properties = properties;
        }

        public synchronized void active() {
            this.cache = null;
            this.state = ComponentState.ACTIVE;
            this.processingThread = null;
        }

        public synchronized void addServiceRegistration(ServiceRegistration<?> serviceRegistration) {
            this.cache = null;
            this.serviceRegistrations.add(serviceRegistration);
        }

        public synchronized ComponentRevisionImpl<C> build() {
            ComponentRevisionImpl<C> componentRevisionImpl;
            if (this.cache != null && (componentRevisionImpl = this.cache.get()) != null) {
                return componentRevisionImpl;
            }
            componentRevisionImpl = new ComponentRevisionImpl(this);
            this.cache = new SoftReference<ComponentRevisionImpl<C>>(componentRevisionImpl);
            return componentRevisionImpl;
        }

        public synchronized void fail(Throwable cause, boolean permanent) {
            this.cache = null;
            this.cause = cause;
            this.processingThread = null;
            this.state = permanent ? ComponentState.FAILED_PERMANENT : ComponentState.FAILED;
        }

        public synchronized Set<ServiceRegistration<?>> getCloneOfServiceRegistrations() {
            Set result = (Set)this.serviceRegistrations.clone();
            return result;
        }

        public synchronized Map<String, Object> getProperties() {
            return this.properties;
        }

        public synchronized ComponentState getState() {
            return this.state;
        }

        public synchronized void inactive() {
            this.cache = null;
            this.processingThread = null;
            this.cause = null;
            this.state = ComponentState.INACTIVE;
        }

        public synchronized void removeServiceRegistration(ServiceRegistration<?> serviceRegistration) {
            this.cache = null;
            this.serviceRegistrations.remove(serviceRegistration);
        }

        public synchronized void setOrAddSuppressedCause(Throwable cause) {
            if (this.cause == null) {
                this.cause = cause;
            } else {
                this.cause.addSuppressed(cause);
            }
        }

        public synchronized void starting() {
            this.cache = null;
            this.state = ComponentState.STARTING;
            this.cause = null;
            this.processingThread = Thread.currentThread();
        }

        public synchronized void stopping() {
            this.cache = null;
            this.state = ComponentState.STOPPING;
            this.processingThread = Thread.currentThread();
        }

        public synchronized void unsatisfied() {
            this.cache = null;
            this.state = ComponentState.UNSATISFIED;
            this.processingThread = null;
            this.cause = null;
        }

        public synchronized void updateProperties(Map<String, Object> properties) {
            this.cache = null;
            this.properties = properties;
        }

        public synchronized void updateSuitingsForAttribute(ReferenceMetadata referenceMetadata, Suiting<?>[] suitings) {
            this.cache = null;
            this.suitingsByAttributeIds.put(referenceMetadata, suitings);
        }

        public synchronized void updatingConfiguration() {
            this.cache = null;
            this.processingThread = Thread.currentThread();
            this.cause = null;
            this.state = ComponentState.UPDATING_CONFIGURATION;
        }
    }
}

