/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal.attribute;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.everit.osgi.capabilitycollector.AbstractCapabilityCollector;
import org.everit.osgi.capabilitycollector.CapabilityConsumer;
import org.everit.osgi.capabilitycollector.RequirementDefinition;
import org.everit.osgi.capabilitycollector.ServiceReferenceCollector;
import org.everit.osgi.capabilitycollector.Suiting;
import org.everit.osgi.ecm.component.ServiceHolder;
import org.everit.osgi.ecm.component.ri.internal.ComponentContextImpl;
import org.everit.osgi.ecm.component.ri.internal.ReferenceEventHandler;
import org.everit.osgi.ecm.component.ri.internal.attribute.ReferenceHelper;
import org.everit.osgi.ecm.metadata.ServiceReferenceMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;

public class ServiceReferenceAttributeHelper<S, COMPONENT>
extends ReferenceHelper<ServiceReference<S>, COMPONENT, ServiceReferenceMetadata> {
    private Map<String, SuitingWithService<S>> previousSuitingsByRequirementId = new TreeMap<String, SuitingWithService<S>>();
    private Class<S> serviceClass;
    private final Map<ServiceReference<S>, ServiceObjectsWithCounter<S>> serviceObjectsByReferences = new HashMap<ServiceReference<S>, ServiceObjectsWithCounter<S>>();

    public ServiceReferenceAttributeHelper(ServiceReferenceMetadata referenceMetadata, ComponentContextImpl<COMPONENT> componentContext, ReferenceEventHandler eventHandler) throws IllegalAccessException {
        super(referenceMetadata, componentContext, eventHandler);
    }

    private S addToUsedServiceReferences(ServiceReference<S> serviceReference) {
        ServiceObjectsWithCounter<S> serviceObjectsWithCounter = this.serviceObjectsByReferences.get(serviceReference);
        if (serviceObjectsWithCounter == null) {
            serviceObjectsWithCounter = new ServiceObjectsWithCounter();
            serviceObjectsWithCounter.serviceObjects = this.getComponentContext().getBundleContext().getServiceObjects(serviceReference);
            this.serviceObjectsByReferences.put(serviceReference, serviceObjectsWithCounter);
        }
        Object service = serviceObjectsWithCounter.serviceObjects.getService();
        ++serviceObjectsWithCounter.counter;
        return (S)service;
    }

    @Override
    protected synchronized void bindInternal() {
        TreeMap<String, SuitingWithService<S>> newSuitingMapping = new TreeMap<String, SuitingWithService<S>>();
        Suiting<CAPABILITY>[] tmpSuitings = this.getSuitings();
        Object[] parameter = this.resolveParameterArray(tmpSuitings);
        for (int i = 0; i < tmpSuitings.length; ++i) {
            S service;
            Suiting suiting = tmpSuitings[i];
            ServiceReference serviceReference = (ServiceReference)suiting.getCapability();
            RequirementDefinition requirement = suiting.getRequirement();
            String requirementId = suiting.getRequirement().getRequirementId();
            SuitingWithService<S> previousSuitingWithService = this.previousSuitingsByRequirementId.get(requirementId);
            if (previousSuitingWithService == null || ((ServiceReference)previousSuitingWithService.suiting.getCapability()).compareTo(suiting.getCapability()) != 0) {
                service = this.addToUsedServiceReferences(serviceReference);
                if (service != null) {
                    SuitingWithService suitingWithService = new SuitingWithService();
                    suitingWithService.service = service;
                    suitingWithService.suiting = suiting;
                    newSuitingMapping.put(requirementId, suitingWithService);
                }
            } else {
                this.previousSuitingsByRequirementId.remove(requirementId);
                service = previousSuitingWithService.service;
                newSuitingMapping.put(requirementId, previousSuitingWithService);
            }
            if (this.isHolder()) {
                ServiceHolder serviceHolder = new ServiceHolder(suiting.getRequirement().getRequirementId(), serviceReference, service, requirement.getAttributes());
                parameter[i] = serviceHolder;
                continue;
            }
            parameter[i] = service;
        }
        this.callSetterWithParameters(parameter);
        Collection<SuitingWithService<S>> previousSuitings = this.previousSuitingsByRequirementId.values();
        for (SuitingWithService<S> suitingWithService : previousSuitings) {
            this.removeFromUsedServiceReferences(suitingWithService);
        }
        this.previousSuitingsByRequirementId = newSuitingMapping;
    }

    private void callSetterWithParameters(Object[] parameter) {
        MethodHandle setterMethod = this.getSetterMethodHandle();
        if (this.isArray()) {
            try {
                setterMethod.invoke(this.getComponentContext().getInstance(), parameter);
            }
            catch (Throwable e) {
                this.getComponentContext().fail(e, false);
            }
        } else {
            try {
                if (parameter.length == 0) {
                    setterMethod.invoke(this.getComponentContext().getInstance(), null);
                } else {
                    setterMethod.invoke(this.getComponentContext().getInstance(), parameter[0]);
                }
            }
            catch (Throwable e) {
                this.getComponentContext().fail(e, false);
            }
        }
    }

    @Override
    public synchronized void close() {
        super.close();
        this.releaseServices();
    }

    @Override
    protected AbstractCapabilityCollector<ServiceReference<S>> createCollector(ReferenceHelper.ReferenceCapabilityConsumer consumer, RequirementDefinition<ServiceReference<S>>[] items) {
        return new ServiceReferenceCollector(this.getComponentContext().getBundleContext(), this.serviceClass, items, (CapabilityConsumer)consumer, false);
    }

    @Override
    public void free() {
        this.releaseServices();
    }

    @Override
    protected void init() {
        String serviceInterfaceName = ((ServiceReferenceMetadata)this.getReferenceMetadata()).getServiceInterface();
        if (serviceInterfaceName == null) {
            return;
        }
        Bundle bundle = this.getComponentContext().getBundleContext().getBundle();
        ClassLoader classLoader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
        try {
            Class<?> tmpServiceClass = Class.forName(serviceInterfaceName, true, classLoader);
            this.serviceClass = tmpServiceClass;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void releaseServices() {
        Collection<SuitingWithService<S>> suitingsWithServices = this.previousSuitingsByRequirementId.values();
        for (SuitingWithService<S> suitingWithService : suitingsWithServices) {
            this.removeFromUsedServiceReferences(suitingWithService);
        }
        this.serviceObjectsByReferences.clear();
        this.previousSuitingsByRequirementId.clear();
    }

    private void removeFromUsedServiceReferences(SuitingWithService<S> suitingWithService) {
        Object service = suitingWithService.service;
        if (service != null) {
            ServiceReference serviceReference = (ServiceReference)suitingWithService.suiting.getCapability();
            ServiceObjectsWithCounter<S> serviceObjectsWithCounter = this.serviceObjectsByReferences.get(serviceReference);
            serviceObjectsWithCounter.serviceObjects.ungetService(service);
            --serviceObjectsWithCounter.counter;
            if (serviceObjectsWithCounter.counter == 0) {
                this.serviceObjectsByReferences.remove(serviceReference);
            }
        }
    }

    private Object[] resolveParameterArray(Suiting<ServiceReference<S>>[] tmpSuitings) {
        Object[] parameter = this.isHolder() ? new ServiceHolder[tmpSuitings.length] : (Object[])Array.newInstance(this.serviceClass, tmpSuitings.length);
        return parameter;
    }

    private static class SuitingWithService<S> {
        public S service;
        public Suiting<ServiceReference<S>> suiting;

        private SuitingWithService() {
        }
    }

    private static class ServiceObjectsWithCounter<S> {
        public int counter = 0;
        public ServiceObjects<S> serviceObjects;

        private ServiceObjectsWithCounter() {
        }
    }
}

