/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal.attribute;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.everit.osgi.ecm.component.ConfigurationException;
import org.everit.osgi.ecm.component.PasswordHolder;
import org.everit.osgi.ecm.component.ri.internal.ComponentContextImpl;
import org.everit.osgi.ecm.metadata.AttributeMetadata;
import org.everit.osgi.ecm.metadata.ComponentMetadata;

public final class PropertyAttributeUtil {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_BOXING_TYPE_MAPPING;
    private final AttributeMetadata<?> attributeMetadata;
    private final ComponentContextImpl<?> componentContext;

    public static void checkAttributeOptional(ComponentContextImpl<?> componentContextImpl, AttributeMetadata<?> attributeMetadata) {
        if (!attributeMetadata.isOptional()) {
            PropertyAttributeUtil.failDuringValueResolution("Mandatory attribute is not specified", componentContextImpl, attributeMetadata);
        }
    }

    public static void failDuringValueResolution(String message, ComponentContextImpl<?> componentContext, AttributeMetadata<?> attributeMetadata) {
        Map<String, Object> properties = componentContext.getProperties();
        String servicePid = (String)properties.get("service.pid");
        ComponentMetadata componentMetadata = componentContext.getComponentContainer().getComponentMetadata();
        if (servicePid == null) {
            servicePid = componentMetadata.getComponentId();
        }
        ConfigurationException e = new ConfigurationException("Error during updating attribute '" + attributeMetadata.getAttributeId() + "' in configuration of component '" + servicePid + "' declared in class '" + componentMetadata.getType() + "': " + message);
        throw e;
    }

    public static Object resolveSimpleValueEvenIfItIsInOneElementArray(Object valueObject, ComponentContextImpl<?> componentContext, AttributeMetadata<?> attributeMetadata) {
        if (valueObject == null) {
            PropertyAttributeUtil.checkAttributeOptional(componentContext, attributeMetadata);
        }
        Object simpleValue = valueObject;
        Class<?> valueClass = valueObject.getClass();
        if (valueClass.isArray()) {
            int length = Array.getLength(valueObject);
            if (length == 0) {
                if (!attributeMetadata.isOptional()) {
                    PropertyAttributeUtil.failDuringValueResolution("Mandatory non-array attribute cannot be specified with an empty array.", componentContext, attributeMetadata);
                }
                return null;
            }
            if (length > 1) {
                PropertyAttributeUtil.failDuringValueResolution("Simple value of attribute cannot be specified with an array that has more than one elements", componentContext, attributeMetadata);
                return null;
            }
            simpleValue = Array.get(valueObject, 0);
        }
        if (simpleValue == null) {
            PropertyAttributeUtil.checkAttributeOptional(componentContext, attributeMetadata);
        }
        return simpleValue;
    }

    public static Object tryConvertingSimpleValue(Object simpleValue, Class<?> targetType, ComponentContextImpl<?> componentContext, AttributeMetadata<?> attributeMetadata) {
        Class<?> originalValueType = simpleValue.getClass();
        if (originalValueType.equals(targetType)) {
            return simpleValue;
        }
        PropertyAttributeUtil instance = new PropertyAttributeUtil(componentContext, attributeMetadata);
        if (simpleValue instanceof String) {
            return instance.tryConvertingStringValueToAttributeType(simpleValue, targetType);
        }
        if (simpleValue instanceof PasswordHolder && targetType.equals(String.class)) {
            return ((PasswordHolder)simpleValue).getPassword();
        }
        instance.failOnIncomaptibleSimpleType(originalValueType, targetType);
        return null;
    }

    public static boolean typesEqualWithOrWithoutBoxing(Class<? extends Object> type1, Class<?> type2) {
        return type1.equals(type2) || type2.equals(PRIMITIVE_BOXING_TYPE_MAPPING.get(type1)) || type1.equals(PRIMITIVE_BOXING_TYPE_MAPPING.get(type2));
    }

    private PropertyAttributeUtil(ComponentContextImpl<?> componentContextImpl, AttributeMetadata<?> attributeMetadata) {
        this.componentContext = componentContextImpl;
        this.attributeMetadata = attributeMetadata;
    }

    private Object convertNonEmptyStringAttributeValueToChar(String stringValue) {
        if (stringValue.length() == 1) {
            return Character.valueOf(stringValue.charAt(0));
        }
        if (stringValue.length() > 1) {
            PropertyAttributeUtil.failDuringValueResolution("String value with multiple characters cannot be converted to char type", this.componentContext, this.attributeMetadata);
        }
        return null;
    }

    private void failOnIncomaptibleSimpleType(Class<? extends Object> valueType, Class<?> attributeType) {
        StringBuilder sb = new StringBuilder();
        if (attributeType.isPrimitive()) {
            sb.append("Either ").append(PRIMITIVE_BOXING_TYPE_MAPPING.get(attributeType).getCanonicalName()).append(" or ");
        }
        sb.append(attributeType.getCanonicalName()).append(" was expected, but got ").append(valueType.getCanonicalName());
        PropertyAttributeUtil.failDuringValueResolution(sb.toString(), this.componentContext, this.attributeMetadata);
    }

    private Object tryConvertingStringValueToAttributeType(Object simpleValue, Class<?> targetType) {
        String stringValue = (String)simpleValue;
        if (Character.TYPE.equals(targetType)) {
            return this.convertNonEmptyStringAttributeValueToChar(stringValue);
        }
        if ("".equals(stringValue.trim())) {
            PropertyAttributeUtil.checkAttributeOptional(this.componentContext, this.attributeMetadata);
            return null;
        }
        if (Boolean.TYPE.equals(targetType)) {
            return Boolean.valueOf(stringValue);
        }
        return this.tryConvertingStringValueToNumberOrFail(stringValue, targetType);
    }

    private Object tryConvertingStringValueToNumberOrFail(String stringValue, Class<?> attributeType) {
        try {
            if (Byte.TYPE.equals(attributeType)) {
                return Byte.valueOf(stringValue);
            }
            if (Double.TYPE.equals(attributeType)) {
                return Double.valueOf(stringValue);
            }
            if (Float.TYPE.equals(attributeType)) {
                return Float.valueOf(stringValue);
            }
            if (Integer.TYPE.equals(attributeType)) {
                return Integer.valueOf(stringValue);
            }
            if (Long.TYPE.equals(attributeType)) {
                return Long.valueOf(stringValue);
            }
            if (Short.TYPE.equals(attributeType)) {
                return Short.valueOf(stringValue);
            }
        }
        catch (NumberFormatException e) {
            PropertyAttributeUtil.failDuringValueResolution("String value \"" + stringValue + "\" cannot be converted to type '" + attributeType.getCanonicalName() + "'", this.componentContext, this.attributeMetadata);
        }
        this.failOnIncomaptibleSimpleType(String.class, attributeType);
        return null;
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Class> primitiveBoxingTypeMapping = new HashMap<Class<Comparable<Boolean>>, Class>();
        primitiveBoxingTypeMapping.put(Boolean.TYPE, Boolean.class);
        primitiveBoxingTypeMapping.put(Byte.TYPE, Byte.class);
        primitiveBoxingTypeMapping.put(Character.TYPE, Character.class);
        primitiveBoxingTypeMapping.put(Double.TYPE, Double.class);
        primitiveBoxingTypeMapping.put(Float.TYPE, Float.class);
        primitiveBoxingTypeMapping.put(Integer.TYPE, Integer.class);
        primitiveBoxingTypeMapping.put(Long.TYPE, Long.class);
        primitiveBoxingTypeMapping.put(Short.TYPE, Short.class);
        PRIMITIVE_BOXING_TYPE_MAPPING = Collections.unmodifiableMap(primitiveBoxingTypeMapping);
    }
}

