/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal.attribute;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.everit.osgi.ecm.component.PasswordHolder;
import org.everit.osgi.ecm.component.ri.internal.ComponentContextImpl;
import org.everit.osgi.ecm.component.ri.internal.IllegalMetadataException;
import org.everit.osgi.ecm.component.ri.internal.attribute.PropertyAttributeUtil;
import org.everit.osgi.ecm.metadata.PasswordAttributeMetadata;
import org.everit.osgi.ecm.metadata.PropertyAttributeMetadata;
import org.everit.osgi.ecm.util.method.MethodDescriptor;

public class PropertyAttributeHelper<C, V_ARRAY> {
    private final PropertyAttributeMetadata<V_ARRAY> attributeMetadata;
    private final ComponentContextImpl<C> componentContext;
    private final MethodHandle methodHandle;
    private Class<?> parameterClass;

    public PropertyAttributeHelper(ComponentContextImpl<C> componentContext, PropertyAttributeMetadata<V_ARRAY> attributeMetadata) {
        this.componentContext = componentContext;
        this.attributeMetadata = attributeMetadata;
        this.methodHandle = this.resolveMethodHandle();
    }

    public void applyValue(Object newValue) {
        Object parameterValue;
        if (this.methodHandle == null) {
            return;
        }
        try {
            parameterValue = this.resolveValue(newValue);
        }
        catch (RuntimeException e) {
            this.componentContext.fail(e, false);
            return;
        }
        C instance = this.componentContext.getInstance();
        this.methodHandle.bindTo(instance);
        try {
            this.methodHandle.invoke(instance, parameterValue);
        }
        catch (Throwable e) {
            this.componentContext.fail(e, false);
        }
    }

    public PropertyAttributeMetadata<V_ARRAY> getAttributeMetadata() {
        return this.attributeMetadata;
    }

    private MethodHandle resolveMethodHandle() {
        Method setter = this.resolveSetter();
        if (setter == null) {
            return null;
        }
        this.parameterClass = setter.getParameterTypes()[0];
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.unreflect(setter);
        }
        catch (IllegalAccessException e) {
            this.componentContext.fail(e, true);
            return null;
        }
    }

    private Object resolveMultiPasswordParamValue(Object valueObject) {
        Class<?> componentType = valueObject.getClass().getComponentType();
        if (!PasswordHolder.class.equals(componentType) && !String.class.equals(componentType)) {
            PropertyAttributeUtil.failDuringValueResolution("Either 'String[]' or 'PasswordHolder[]' was expected, but got '" + componentType + "[]'", this.componentContext, this.attributeMetadata);
            return null;
        }
        if (componentType.equals(String.class)) {
            String[] stringPasswordArray = (String[])valueObject;
            PasswordHolder[] result = new PasswordHolder[stringPasswordArray.length];
            for (int i = 0; i < stringPasswordArray.length; ++i) {
                result[i] = new PasswordHolder(stringPasswordArray[i]);
            }
            return result;
        }
        PasswordHolder[] passwordHolderArray = (PasswordHolder[])valueObject;
        String[] result = new String[passwordHolderArray.length];
        for (int i = 0; i < passwordHolderArray.length; ++i) {
            result[i] = passwordHolderArray[i].getPassword();
        }
        return result;
    }

    private Object resolveNonExactTypeMatchMultiValue(Object valueObject) {
        Class<?> valueClass = valueObject.getClass();
        if (!valueClass.isArray()) {
            PropertyAttributeUtil.failDuringValueResolution("An array was expected as value , but got '" + valueClass.getCanonicalName() + '\'', this.componentContext, this.attributeMetadata);
            return null;
        }
        if (!(this.attributeMetadata instanceof PasswordAttributeMetadata)) {
            PropertyAttributeUtil.failDuringValueResolution("'" + this.parameterClass.getCanonicalName() + "' was expected, but got '" + valueClass.getCanonicalName() + "'", this.componentContext, this.attributeMetadata);
        }
        return this.resolveMultiPasswordParamValue(valueObject);
    }

    private Method resolveSetter() {
        MethodDescriptor setterMethodDescriptor = this.attributeMetadata.getSetter();
        if (setterMethodDescriptor == null) {
            return null;
        }
        Method method = setterMethodDescriptor.locate(this.componentContext.getComponentType(), false);
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            this.throwIllegalSetter(method, "Setter method must have one parameter: " + method.toGenericString());
            return null;
        }
        if (this.attributeMetadata.isMultiple()) {
            return this.resolveSetterForMultipleCardinalityAttribute(method, parameterTypes);
        }
        return this.resolveSetterForSimpleAttribute(method, parameterTypes);
    }

    private Method resolveSetterForMultipleCardinalityAttribute(Method method, Class<?>[] parameterTypes) {
        if (!parameterTypes[0].isArray()) {
            this.throwIllegalSetter(method, "Parameter type should be an array");
            return null;
        }
        Class<?> componentType = parameterTypes[0].getComponentType();
        Class expectedComponentType = this.attributeMetadata.getValueType();
        if (!expectedComponentType.equals(componentType)) {
            if (this.attributeMetadata instanceof PasswordAttributeMetadata) {
                if (!PasswordHolder.class.equals(componentType)) {
                    this.throwIllegalSetter(method, "Parameter type should be either String[] or PasswordVaueHolder[].");
                    return null;
                }
            } else {
                this.throwIllegalSetter(method, "Parameter array should have '" + expectedComponentType + "' component type.");
                return null;
            }
        }
        return method;
    }

    private Method resolveSetterForSimpleAttribute(Method method, Class<?>[] parameterTypes) {
        Class valueType = this.attributeMetadata.getValueType();
        if (!valueType.equals(parameterTypes[0])) {
            if (valueType.isPrimitive()) {
                Class<?> boxingType = PropertyAttributeUtil.PRIMITIVE_BOXING_TYPE_MAPPING.get(valueType);
                if (!boxingType.equals(parameterTypes[0])) {
                    this.throwIllegalSetter(method, " Parameter should be " + valueType.getCanonicalName() + " or " + boxingType.getCanonicalName() + ": " + method.toGenericString());
                    return null;
                }
            } else if (this.attributeMetadata instanceof PasswordAttributeMetadata) {
                if (!PasswordHolder.class.equals(parameterTypes[0])) {
                    this.throwIllegalSetter(method, "Parameter type should be either String or PasswordVaueHolder");
                }
            } else {
                this.throwIllegalSetter(method, " Parameter type should be " + valueType.getCanonicalName() + ": " + method.toGenericString());
            }
        }
        return method;
    }

    private Object resolveSimplePasswordParamValue(Object simpleValue, Class<?> originalValueType) {
        Class<?> valueType = simpleValue.getClass();
        if (!String.class.equals(valueType) && !PasswordHolder.class.equals(valueType)) {
            PropertyAttributeUtil.failDuringValueResolution("Either 'String[]' or 'PasswordHolder[]' was expected, but got '" + originalValueType + "'", this.componentContext, this.attributeMetadata);
            return null;
        }
        if (String.class.equals(valueType)) {
            return new PasswordHolder((String)simpleValue);
        }
        return ((PasswordHolder)simpleValue).getPassword();
    }

    private Object resolveSimpleValue(Object valueObject) {
        Object simpleValue = PropertyAttributeUtil.resolveSimpleValueEvenIfItIsInOneElementArray(valueObject, this.componentContext, this.attributeMetadata);
        if (this.componentContext.isFailed()) {
            return null;
        }
        Class<?> simpleValueClass = simpleValue.getClass();
        if (simpleValueClass.equals(this.parameterClass)) {
            return simpleValue;
        }
        if (this.attributeMetadata instanceof PasswordAttributeMetadata) {
            return this.resolveSimplePasswordParamValue(simpleValue, valueObject.getClass());
        }
        if (PropertyAttributeUtil.typesEqualWithOrWithoutBoxing(this.parameterClass, simpleValueClass)) {
            return simpleValue;
        }
        return PropertyAttributeUtil.tryConvertingSimpleValue(simpleValue, this.parameterClass, this.componentContext, this.attributeMetadata);
    }

    private Object resolveValue(Object valueObject) {
        if (valueObject == null) {
            PropertyAttributeUtil.checkAttributeOptional(this.componentContext, this.attributeMetadata);
            return null;
        }
        if (this.parameterClass.equals(valueObject.getClass())) {
            return valueObject;
        }
        if (this.attributeMetadata.isMultiple()) {
            return this.resolveNonExactTypeMatchMultiValue(valueObject);
        }
        return this.resolveSimpleValue(valueObject);
    }

    private void throwIllegalSetter(Method method, String additionalMessage) {
        IllegalMetadataException e = new IllegalMetadataException("Invalid setter '" + method.toGenericString() + "' defined for attribute '" + this.attributeMetadata.getAttributeId() + "' of component '" + this.componentContext.getComponentContainer().getComponentMetadata().getComponentId() + "'. " + additionalMessage);
        this.componentContext.fail(e, true);
    }
}

