/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.component.PasswordHolder;
import org.everit.osgi.ecm.component.resource.ComponentContainer;
import org.everit.osgi.ecm.component.resource.ComponentState;
import org.everit.osgi.ecm.component.ri.internal.AbstractComponentContainer;
import org.everit.osgi.ecm.component.ri.internal.ActivateMethodHelper;
import org.everit.osgi.ecm.component.ri.internal.ComponentServiceRegistration;
import org.everit.osgi.ecm.component.ri.internal.IllegalMetadataException;
import org.everit.osgi.ecm.component.ri.internal.ReferenceEventHandler;
import org.everit.osgi.ecm.component.ri.internal.attribute.BundleCapabilityReferenceAttributeHelper;
import org.everit.osgi.ecm.component.ri.internal.attribute.PropertyAttributeHelper;
import org.everit.osgi.ecm.component.ri.internal.attribute.PropertyAttributeUtil;
import org.everit.osgi.ecm.component.ri.internal.attribute.ReferenceHelper;
import org.everit.osgi.ecm.component.ri.internal.attribute.ServiceReferenceAttributeHelper;
import org.everit.osgi.ecm.component.ri.internal.resource.ComponentRevisionImpl;
import org.everit.osgi.ecm.metadata.AttributeMetadata;
import org.everit.osgi.ecm.metadata.BundleCapabilityReferenceMetadata;
import org.everit.osgi.ecm.metadata.ComponentMetadata;
import org.everit.osgi.ecm.metadata.PasswordAttributeMetadata;
import org.everit.osgi.ecm.metadata.PropertyAttributeMetadata;
import org.everit.osgi.ecm.metadata.ReferenceMetadata;
import org.everit.osgi.ecm.metadata.ServiceMetadata;
import org.everit.osgi.ecm.metadata.ServiceReferenceMetadata;
import org.everit.osgi.ecm.util.method.MethodDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.log.LogService;

public class ComponentContextImpl<C>
implements ComponentContext<C> {
    private ActivateMethodHelper<C> activateMethodHelper;
    private final BundleContext bundleContext;
    private final AbstractComponentContainer<C> componentContainer;
    private Class<C> componentType;
    private String componentTypeName;
    private boolean configurationUpdateInProgress = false;
    private Method deactivateMethod;
    private C instance;
    private final LogService logService;
    private boolean opened = false;
    private final List<PropertyAttributeHelper<C, Object>> propertyAttributeHelpers = new ArrayList<PropertyAttributeHelper<C, Object>>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReferenceEventHandler referenceEventHandler = new ReferenceEventHandlerImpl();
    private final List<ReferenceHelper<?, C, ?>> referenceHelpers = new ArrayList();
    private final ComponentRevisionImpl.Builder<C> revisionBuilder;
    private final Set<ReferenceHelper<?, ?, ?>> satisfiedReferenceHelpers = new HashSet();
    private String[] serviceInterfaces;
    private ServiceRegistration<?> serviceRegistration = null;
    private Method updateMethod;

    private static void resolveSuperInterfacesRecurse(Class<?> currentClass, Set<String> interfaces) {
        Class<?>[] superInterfaces;
        for (Class<?> superInterface : superInterfaces = currentClass.getInterfaces()) {
            interfaces.add(superInterface.getName());
            ComponentContextImpl.resolveSuperInterfacesRecurse(superInterface, interfaces);
        }
    }

    public ComponentContextImpl(AbstractComponentContainer<C> componentContainer, BundleContext bundleContext, Dictionary<String, Object> properties, LogService logService) {
        this.bundleContext = bundleContext;
        this.componentContainer = componentContainer;
        this.logService = logService;
        Map<String, Object> propertyMap = this.createPropMapFromConfigDictionary(properties);
        this.revisionBuilder = new ComponentRevisionImpl.Builder<C>(componentContainer, propertyMap);
        this.revisionBuilder.updateProperties(this.resolveProperties(propertyMap, false));
        ComponentMetadata componentMetadata = componentContainer.getComponentMetadata();
        Bundle bundle = bundleContext.getBundle();
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        ClassLoader classLoader = bundleWiring.getClassLoader();
        this.componentTypeName = componentMetadata.getType();
        try {
            Class<?> tmpComponentType = classLoader.loadClass(this.componentTypeName);
            this.componentType = tmpComponentType;
        }
        catch (ClassNotFoundException e) {
            this.fail(e, true);
            return;
        }
        this.activateMethodHelper = new ActivateMethodHelper(this);
        if (this.isFailed()) {
            return;
        }
        AttributeMetadata[] attributes = componentMetadata.getAttributes();
        this.fillAttributeHelpers(attributes);
        this.serviceInterfaces = this.resolveServiceInterfaces();
        this.deactivateMethod = this.resolveAnnotatedMethod("deactivate", componentContainer.getComponentMetadata().getDeactivate());
        this.updateMethod = this.resolveAnnotatedMethod("update", componentContainer.getComponentMetadata().getUpdate());
    }

    private void addCommonComponentProperties(Map<String, Object> properties) {
        ComponentMetadata componentMetadata = this.componentContainer.getComponentMetadata();
        properties.put("org.everit.osgi.ecm.component.id", componentMetadata.getComponentId());
        properties.put("org.everit.osgi.ecm.component.version", this.componentContainer.getVersion());
    }

    private void callUpdateMethod() {
        if (this.updateMethod != null) {
            try {
                this.updateMethod.invoke(this.instance, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.fail(e, false);
            }
        }
    }

    public void close() {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (!this.opened) {
                throw new IllegalStateException("Cannot close a component context that is not opened");
            }
            this.opened = false;
            if (this.getState() == ComponentState.ACTIVE) {
                this.stopping(ComponentState.INACTIVE);
            } else {
                this.closeReferenceHelpers();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private void closeReferenceHelpers() {
        for (ReferenceHelper<?, C, ?> referenceHelper : this.referenceHelpers) {
            if (!referenceHelper.isOpened()) continue;
            referenceHelper.close();
        }
    }

    private void convertAttributeValueIfNecessary(AttributeMetadata<?> attributeMetadata, Map<String, Object> result) {
        Class<PasswordHolder> attributeType;
        if (attributeMetadata.isMultiple()) {
            return;
        }
        String attributeId = attributeMetadata.getAttributeId();
        Object attributeValue = result.get(attributeId);
        if ((attributeValue = PropertyAttributeUtil.resolveSimpleValueEvenIfItIsInOneElementArray(attributeValue, this, attributeMetadata)) == null) {
            return;
        }
        Class<?> configuredAttributeValueType = attributeValue.getClass();
        if (PropertyAttributeUtil.typesEqualWithOrWithoutBoxing(configuredAttributeValueType, attributeType = attributeMetadata.getValueType())) {
            return;
        }
        if (attributeValue instanceof PasswordHolder) {
            attributeType = PasswordHolder.class;
        }
        Object newAttributeValue = PropertyAttributeUtil.tryConvertingSimpleValue(attributeValue, attributeType, this, attributeMetadata);
        result.put(attributeId, newAttributeValue);
    }

    private Map<String, Object> createPropMapFromConfigDictionary(Dictionary<String, ?> props) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (props != null) {
            Enumeration<?> elements = props.elements();
            Enumeration<String> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Object element = elements.nextElement();
                result.put(key, element);
            }
        }
        return result;
    }

    private boolean equals(Object oldValue, Object newValue) {
        if (oldValue == null && newValue != null || oldValue != null && newValue == null) {
            return false;
        }
        if (oldValue != null && !oldValue.equals(newValue)) {
            Class<?> newValueClass;
            Class<?> oldValueClass = oldValue.getClass();
            if (!oldValueClass.equals(newValueClass = newValue.getClass()) || !oldValueClass.isArray()) {
                return false;
            }
            boolean equals = oldValueClass.equals(boolean[].class) ? Arrays.equals((boolean[])oldValue, (boolean[])newValue) : (oldValueClass.equals(byte[].class) ? Arrays.equals((byte[])oldValue, (byte[])newValue) : (oldValueClass.equals(char[].class) ? Arrays.equals((char[])oldValue, (char[])newValue) : (oldValueClass.equals(double[].class) ? Arrays.equals((double[])oldValue, (double[])newValue) : (oldValueClass.equals(float[].class) ? Arrays.equals((float[])oldValue, (float[])newValue) : (oldValueClass.equals(int[].class) ? Arrays.equals((int[])oldValue, (int[])newValue) : (oldValueClass.equals(long[].class) ? Arrays.equals((long[])oldValue, (long[])newValue) : (oldValueClass.equals(short[].class) ? Arrays.equals((short[])oldValue, (short[])newValue) : Arrays.equals((Object[])oldValue, (Object[])newValue))))))));
            if (!equals) {
                return false;
            }
        }
        return true;
    }

    public void fail(Throwable e, boolean permanent) {
        boolean stopComponent = false;
        if (this.getState() == ComponentState.ACTIVE) {
            stopComponent = true;
        }
        this.fail(e, permanent, stopComponent);
    }

    private void fail(Throwable e, boolean permanent, boolean stopComponent) {
        this.logService.log(1, "Component error: {id: '" + this.componentContainer.getComponentMetadata().getComponentId() + "', state: " + this.revisionBuilder.getState().toString() + ", properties: " + this.revisionBuilder.getProperties().toString() + "}", e);
        this.revisionBuilder.setOrAddSuppressedCause(e);
        if (this.isFailed()) {
            return;
        }
        if (stopComponent) {
            this.stopping(ComponentState.FAILED);
        } else {
            this.instance = null;
        }
        this.revisionBuilder.fail(e, permanent);
    }

    private void fillAttributeHelpers(AttributeMetadata<?>[] attributes) {
        for (AttributeMetadata<?> attributeMetadata : attributes) {
            ReferenceHelper helper;
            if (attributeMetadata instanceof PropertyAttributeMetadata) {
                PropertyAttributeHelper propertyAttributeHelper = new PropertyAttributeHelper(this, (PropertyAttributeMetadata)attributeMetadata);
                this.propertyAttributeHelpers.add(propertyAttributeHelper);
                continue;
            }
            try {
                helper = attributeMetadata instanceof ServiceReferenceMetadata ? new ServiceReferenceAttributeHelper((ServiceReferenceMetadata)attributeMetadata, this, this.referenceEventHandler) : new BundleCapabilityReferenceAttributeHelper((BundleCapabilityReferenceMetadata)attributeMetadata, this, this.referenceEventHandler);
            }
            catch (IllegalAccessException | RuntimeException e) {
                this.fail(e, true);
                return;
            }
            this.referenceHelpers.add(helper);
        }
    }

    private void freeReferences() {
        for (ReferenceHelper<?, C, ?> referenceHelper : this.referenceHelpers) {
            referenceHelper.free();
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public ComponentContainer<C> getComponentContainer() {
        return this.componentContainer;
    }

    public ComponentRevisionImpl<C> getComponentRevision() {
        return this.revisionBuilder.build();
    }

    public ServiceReference<?> getComponentServiceReference() {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            if (this.serviceRegistration == null) {
                ServiceReference<?> serviceReference = null;
                return serviceReference;
            }
            ServiceReference serviceReference = this.serviceRegistration.getReference();
            return serviceReference;
        }
        finally {
            readLock.unlock();
        }
    }

    public Class<C> getComponentType() {
        return this.componentType;
    }

    public String getComponentTypeName() {
        return this.componentTypeName;
    }

    public C getInstance() {
        return this.instance;
    }

    public Map<String, Object> getProperties() {
        return this.revisionBuilder.getProperties();
    }

    public ComponentState getState() {
        return this.revisionBuilder.getState();
    }

    public boolean isFailed() {
        ComponentState state = this.getState();
        return ComponentState.FAILED == state || ComponentState.FAILED_PERMANENT == state;
    }

    public boolean isSatisfied() {
        return this.satisfiedReferenceHelpers.size() == this.referenceHelpers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.opened) {
                throw new IllegalStateException("Cannot open a component context that is already opened");
            }
            this.opened = true;
            if (this.getState() != ComponentState.INACTIVE) {
                return;
            }
            try {
                this.revisionBuilder.updateProperties(this.resolveProperties(this.revisionBuilder.getProperties(), true));
            }
            catch (RuntimeException e) {
                this.revisionBuilder.updateProperties(this.resolveProperties(this.revisionBuilder.getProperties(), false));
                this.fail(e, false);
                writeLock.unlock();
                return;
            }
            if (this.referenceHelpers.size() == 0) {
                this.starting();
            } else {
                for (ReferenceHelper<?, C, ?> referenceAttributeHelper : this.referenceHelpers) {
                    referenceAttributeHelper.open();
                }
                if (this.isFailed()) {
                    return;
                }
                if (this.isSatisfied()) {
                    this.starting();
                } else {
                    this.revisionBuilder.unsatisfied();
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private void prepareConfigurationUpdate(ComponentState stateBeforeUpdate, Map<String, Object> newProperties) {
        if (stateBeforeUpdate == ComponentState.ACTIVE && this.shouldRestartForNewConfiguraiton(newProperties)) {
            this.stopping(ComponentState.UPDATING_CONFIGURATION);
        } else if (stateBeforeUpdate == ComponentState.UNSATISFIED || stateBeforeUpdate == ComponentState.FAILED) {
            this.revisionBuilder.updatingConfiguration();
        }
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        this.validateComponentStateForServiceRegistration();
        ServiceRegistration lServiceRegistration = this.bundleContext.registerService(clazz, service, properties);
        return this.registerServiceInternal(lServiceRegistration);
    }

    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        this.validateComponentStateForServiceRegistration();
        ServiceRegistration lServiceRegistration = this.bundleContext.registerService(clazz, service, properties);
        return this.registerServiceInternal(lServiceRegistration);
    }

    public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
        this.validateComponentStateForServiceRegistration();
        ServiceRegistration lServiceRegistration = this.bundleContext.registerService(clazzes, service, properties);
        return this.registerServiceInternal(lServiceRegistration);
    }

    private <S> ServiceRegistration<S> registerServiceInternal(ServiceRegistration<S> original) {
        ComponentServiceRegistration componentServiceRegistration = new ComponentServiceRegistration(this, original);
        this.revisionBuilder.addServiceRegistration(componentServiceRegistration);
        return componentServiceRegistration;
    }

    void removeServiceRegistration(ServiceRegistration<?> pServiceRegistration) {
        this.revisionBuilder.removeServiceRegistration(pServiceRegistration);
    }

    private void replacePasswordStringsToPasswordHoldersInProperties(Map<String, Object> result, AttributeMetadata<?> attributeMetadata) {
        Object password;
        String attributeId = attributeMetadata.getAttributeId();
        if (attributeMetadata instanceof PasswordAttributeMetadata && result.containsKey(attributeId) && (password = result.get(attributeId)) != null) {
            if (password instanceof String) {
                result.put(attributeId, new PasswordHolder((String)password));
            } else if (password instanceof String[]) {
                String[] passwordStringArray = (String[])password;
                PasswordHolder[] passwordHolderArray = new PasswordHolder[passwordStringArray.length];
                for (int i = 0; i < passwordStringArray.length; ++i) {
                    passwordHolderArray[i] = new PasswordHolder(passwordStringArray[i]);
                }
                result.put(attributeId, passwordHolderArray);
            }
        }
    }

    private Method resolveAnnotatedMethod(String methodType, MethodDescriptor methodDescriptor) {
        IllegalMetadataException exception;
        if (methodDescriptor == null) {
            return null;
        }
        Method method = methodDescriptor.locate(this.componentType, false);
        if (method == null) {
            exception = new IllegalMetadataException("Could not find " + methodType + " method '" + methodDescriptor.toString() + "' for type " + this.componentTypeName);
            this.fail(exception, true);
        }
        if (method.getParameterTypes().length > 0) {
            exception = new IllegalMetadataException(methodType.substring(0, 1).toUpperCase(Locale.getDefault()) + methodType.substring(1) + " method must not have any parameters. Method '" + method.toGenericString() + "' of type " + this.componentTypeName + " does have.");
            this.fail(exception, true);
        }
        return method;
    }

    private Map<String, Object> resolveProperties(Map<String, Object> props, boolean doConversionIfNecessary) {
        AttributeMetadata[] attributes;
        HashMap<String, Object> result = new HashMap<String, Object>(props);
        for (AttributeMetadata attributeMetadata : attributes = this.componentContainer.getComponentMetadata().getAttributes()) {
            String attributeId = attributeMetadata.getAttributeId();
            if (!result.containsKey(attributeId)) {
                Object value;
                Object defaultValue = attributeMetadata.getDefaultValue();
                if (attributeMetadata.isMultiple() && defaultValue != null) {
                    result.put(attributeId, defaultValue);
                } else if (defaultValue != null && Array.getLength(defaultValue) > 0 && (value = Array.get(defaultValue, 0)) != null) {
                    result.put(attributeId, value);
                }
            } else if (doConversionIfNecessary) {
                this.convertAttributeValueIfNecessary(attributeMetadata, result);
            }
            this.replacePasswordStringsToPasswordHoldersInProperties(result, attributeMetadata);
        }
        this.addCommonComponentProperties(result);
        return Collections.unmodifiableMap(result);
    }

    private String[] resolveServiceInterfaces() {
        ServiceMetadata serviceMetadata = this.componentContainer.getComponentMetadata().getService();
        if (serviceMetadata == null) {
            return new String[0];
        }
        String[] clazzes = serviceMetadata.getClazzes();
        if (clazzes.length > 0) {
            return clazzes;
        }
        LinkedHashSet<String> interfaces = new LinkedHashSet<String>();
        Class<C> currentClass = this.componentType;
        ComponentContextImpl.resolveSuperInterfacesRecurse(currentClass, interfaces);
        interfaces.add(this.componentTypeName);
        return interfaces.toArray(new String[interfaces.size()]);
    }

    private void restart() {
        this.stopping(ComponentState.STOPPING);
        if (this.isSatisfied()) {
            this.starting();
        } else {
            this.revisionBuilder.unsatisfied();
        }
    }

    private boolean shouldRestartForNewConfiguraiton(Map<String, Object> newProperties) {
        AttributeMetadata[] componentAttributes = this.componentContainer.getComponentMetadata().getAttributes();
        Map<String, Object> properties = this.getProperties();
        for (AttributeMetadata attributeMetadata : componentAttributes) {
            Object newValue;
            String attributeId;
            Object oldValue;
            if (attributeMetadata.isDynamic() || this.equals(oldValue = properties.get(attributeId = attributeMetadata.getAttributeId()), newValue = newProperties.get(attributeId))) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void starting() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void stopping(ComponentState targetState) {
        block18: {
            try {
                this.revisionBuilder.stopping();
                if (this.serviceRegistration != null) {
                    this.serviceRegistration.unregister();
                    this.serviceRegistration = null;
                }
                if (this.instance == null) break block18;
                if (this.deactivateMethod != null) {
                    try {
                        this.deactivateMethod.invoke(this.instance, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        this.logService.log(1, "Component error: {id: '" + this.componentContainer.getComponentMetadata().getComponentId() + "', state: " + this.revisionBuilder.getState().toString() + ", properties: " + this.revisionBuilder.getProperties().toString() + "}", (Throwable)e);
                        if (targetState == ComponentState.FAILED) {
                            this.revisionBuilder.setOrAddSuppressedCause(e);
                        }
                        e.printStackTrace(System.err);
                    }
                }
                this.unregisterServices();
                this.freeReferences();
                this.instance = null;
            }
            finally {
                switch (targetState) {
                    case INACTIVE: {
                        this.revisionBuilder.inactive();
                        break;
                    }
                    case UNSATISFIED: {
                        this.revisionBuilder.unsatisfied();
                        break;
                    }
                    case UPDATING_CONFIGURATION: {
                        this.revisionBuilder.updatingConfiguration();
                        break;
                    }
                }
            }
        }
    }

    private void unregisterServices() {
        for (ServiceRegistration<?> lServiceRegistration : this.revisionBuilder.getCloneOfServiceRegistrations()) {
            lServiceRegistration.unregister();
        }
    }

    public void updateConfiguration(Dictionary<String, ?> properties) {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        this.configurationUpdateInProgress = true;
        try {
            if (this.getState() == ComponentState.FAILED_PERMANENT) {
                return;
            }
            this.updateConfigurationInLock(properties);
        }
        finally {
            this.configurationUpdateInProgress = false;
            writeLock.unlock();
        }
    }

    private void updateConfigurationInLock(Dictionary<String, ?> properties) {
        Map<String, Object> newProperties;
        ComponentState stateBeforeUpdate = this.getState();
        Map<String, Object> oldProperties = this.getProperties();
        Map<String, Object> newPropertyMap = this.createPropMapFromConfigDictionary(properties);
        try {
            newProperties = this.resolveProperties(newPropertyMap, true);
        }
        catch (RuntimeException e) {
            this.revisionBuilder.updateProperties(this.resolveProperties(newPropertyMap, false));
            this.fail(e, false);
            return;
        }
        this.prepareConfigurationUpdate(stateBeforeUpdate, newProperties);
        this.revisionBuilder.updateProperties(newProperties);
        this.updateReferences(newProperties, oldProperties);
        ComponentState stateAfterReferenceUpdate = this.getState();
        if (stateAfterReferenceUpdate == ComponentState.UNSATISFIED || this.isFailed()) {
            return;
        }
        if (!this.isSatisfied()) {
            if (this.getState() == ComponentState.ACTIVE) {
                this.stopping(ComponentState.UNSATISFIED);
            } else {
                this.revisionBuilder.unsatisfied();
            }
        } else if (stateAfterReferenceUpdate == ComponentState.UPDATING_CONFIGURATION) {
            this.starting();
        } else {
            this.updatePropertiesOnComponentInstance(newProperties, oldProperties);
            if (this.isFailed()) {
                return;
            }
            this.callUpdateMethod();
        }
        if (this.serviceRegistration != null) {
            this.serviceRegistration.setProperties(new Hashtable<String, Object>(newProperties));
        }
    }

    private void updatePropertiesOnComponentInstance(Map<String, Object> newProperties, Map<String, Object> oldProperties) {
        for (PropertyAttributeHelper<C, Object> helper : this.propertyAttributeHelpers) {
            Object newValue;
            String attributeId = helper.getAttributeMetadata().getAttributeId();
            Object oldValue = oldProperties.get(attributeId);
            if (this.equals(oldValue, newValue = newProperties.get(attributeId))) continue;
            helper.applyValue(newValue);
            if (!this.isFailed()) continue;
            return;
        }
    }

    private void updateReferences(Map<String, Object> newProperties, Map<String, Object> oldProperties) {
        for (ReferenceHelper<?, C, ?> referenceHelper : this.referenceHelpers) {
            String attributeId = referenceHelper.getReferenceMetadata().getAttributeId();
            Object newValue = newProperties.get(attributeId);
            Object oldValue = oldProperties.get(attributeId);
            if (!this.equals(oldValue, newValue)) {
                referenceHelper.updateConfiguration();
            }
            if (referenceHelper.isOpened()) continue;
            referenceHelper.open();
        }
    }

    private void validateComponentStateForServiceRegistration() {
        ComponentState state = this.getState();
        if (state != ComponentState.ACTIVE && state != ComponentState.STARTING) {
            throw new IllegalStateException("Service can only be registered in component if the state of the component is ACTIVE or STARTING");
        }
    }

    private class ReferenceEventHandlerImpl
    implements ReferenceEventHandler {
        private ReferenceEventHandlerImpl() {
        }

        @Override
        public void failedDuringConfigurationUpdate(ReferenceHelper<?, ?, ? extends ReferenceMetadata> referenceHelper) {
            Lock writeLock = ComponentContextImpl.this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                ComponentContextImpl.this.satisfiedReferenceHelpers.remove(referenceHelper);
                ComponentContextImpl.this.revisionBuilder.updateSuitingsForAttribute(referenceHelper.getReferenceMetadata(), referenceHelper.getSuitings());
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void satisfied(ReferenceHelper<?, ?, ? extends ReferenceMetadata> referenceHelper) {
            Lock writeLock = ComponentContextImpl.this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                ComponentContextImpl.this.satisfiedReferenceHelpers.add(referenceHelper);
                ComponentContextImpl.this.revisionBuilder.updateSuitingsForAttribute(referenceHelper.getReferenceMetadata(), referenceHelper.getSuitings());
                if (ComponentContextImpl.this.configurationUpdateInProgress) {
                    return;
                }
                ComponentState state = ComponentContextImpl.this.getState();
                if (ComponentContextImpl.this.satisfiedReferenceHelpers.size() == ComponentContextImpl.this.referenceHelpers.size() && (state == ComponentState.UNSATISFIED || state == ComponentState.FAILED)) {
                    ComponentContextImpl.this.starting();
                }
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized void unsatisfied(ReferenceHelper<?, ?, ? extends ReferenceMetadata> referenceHelper) {
            Lock writeLock = ComponentContextImpl.this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                ComponentContextImpl.this.satisfiedReferenceHelpers.remove(referenceHelper);
                ComponentContextImpl.this.revisionBuilder.updateSuitingsForAttribute(referenceHelper.getReferenceMetadata(), referenceHelper.getSuitings());
                if (ComponentContextImpl.this.configurationUpdateInProgress) {
                    return;
                }
                ComponentState state = ComponentContextImpl.this.getState();
                switch (state) {
                    case ACTIVE: {
                        ComponentContextImpl.this.stopping(ComponentState.UNSATISFIED);
                        return;
                    }
                    case FAILED: {
                        ComponentContextImpl.this.revisionBuilder.unsatisfied();
                        return;
                    }
                    case STOPPING: {
                        referenceHelper.free();
                        return;
                    }
                }
                return;
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateDynamicWithoutSatisfactionChange(ReferenceHelper<?, ?, ? extends ReferenceMetadata> referenceHelper) {
            Lock writeLock = ComponentContextImpl.this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                ComponentContextImpl.this.revisionBuilder.updateSuitingsForAttribute(referenceHelper.getReferenceMetadata(), referenceHelper.getSuitings());
                ComponentState state = ComponentContextImpl.this.getState();
                if (state == ComponentState.ACTIVE) {
                    referenceHelper.bind();
                    if (ComponentContextImpl.this.getState() == ComponentState.ACTIVE && !ComponentContextImpl.this.configurationUpdateInProgress) {
                        ComponentContextImpl.this.callUpdateMethod();
                    }
                } else if (state == ComponentState.FAILED && !ComponentContextImpl.this.configurationUpdateInProgress) {
                    ComponentContextImpl.this.starting();
                }
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateNonDynamic(ReferenceHelper<?, ?, ? extends ReferenceMetadata> referenceHelper) {
            Lock writeLock = ComponentContextImpl.this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                ComponentState state = ComponentContextImpl.this.getState();
                if (state == ComponentState.ACTIVE) {
                    ComponentContextImpl.this.revisionBuilder.stopping();
                }
                ComponentContextImpl.this.revisionBuilder.updateSuitingsForAttribute(referenceHelper.getReferenceMetadata(), referenceHelper.getSuitings());
                if (state == ComponentState.ACTIVE) {
                    ComponentContextImpl.this.restart();
                } else if (state == ComponentState.FAILED && !ComponentContextImpl.this.configurationUpdateInProgress) {
                    ComponentContextImpl.this.starting();
                }
            }
            finally {
                writeLock.unlock();
            }
        }
    }
}

