/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.everit.osgi.ecm.component.ri.ComponentContainerInstance;
import org.everit.osgi.ecm.component.ri.internal.metatype.MetatypeProviderImpl;
import org.everit.osgi.ecm.component.ri.internal.resource.ComponentRevisionImpl;
import org.everit.osgi.ecm.metadata.ComponentMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public abstract class AbstractComponentContainer<C>
implements MetaTypeProvider,
ComponentContainerInstance<C> {
    private final BundleContext bundleContext;
    private final ComponentMetadata componentMetadata;
    private final LogService logService;
    private final MetatypeProviderImpl<C> metatypeProvider;
    private ServiceRegistration<?> serviceRegistration = null;
    private final Version version;

    public AbstractComponentContainer(ComponentMetadata componentMetadata, BundleContext bundleContext, LogService logService) {
        this.componentMetadata = componentMetadata;
        this.bundleContext = bundleContext;
        this.logService = logService;
        this.metatypeProvider = new MetatypeProviderImpl(componentMetadata, bundleContext);
        this.version = this.resolveComponentVersion();
    }

    protected void addCommonContainerServiceProperties(Dictionary<String, Object> properties) {
        properties.put("org.everit.osgi.ecm.component.version", this.version);
        properties.put("org.everit.osgi.ecm.component.id", this.componentMetadata.getComponentId());
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public ComponentMetadata getComponentMetadata() {
        return this.componentMetadata;
    }

    public String[] getLocales() {
        return this.metatypeProvider.getLocales();
    }

    protected LogService getLogService() {
        return this.logService;
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        return this.metatypeProvider.getObjectClassDefinition(id, locale);
    }

    public abstract ComponentRevisionImpl<C>[] getResources();

    public ServiceReference<?> getServiceReference() {
        return this.serviceRegistration.getReference();
    }

    public Version getVersion() {
        return this.version;
    }

    public synchronized Wire[] getWires() {
        ComponentRevisionImpl<C>[] componentRevisions = this.getResources();
        if (componentRevisions.length == 0) {
            return new Wire[0];
        }
        if (componentRevisions.length == 1) {
            List<Wire> wires = componentRevisions[0].getWires();
            return wires.toArray(new Wire[wires.size()]);
        }
        ArrayList<Wire> result = new ArrayList<Wire>();
        for (ComponentRevisionImpl<C> componentRevisionImpl : componentRevisions) {
            result.addAll(componentRevisionImpl.getWires());
        }
        return result.toArray(new Wire[result.size()]);
    }

    public Wire[] getWiresByCapability(Capability capability) {
        ComponentRevisionImpl<C>[] componentRevisions = this.getResources();
        if (componentRevisions.length == 0) {
            return new Wire[0];
        }
        if (componentRevisions.length == 1) {
            List<Wire> wires = componentRevisions[0].getWiresByCapability(capability);
            return wires.toArray(new Wire[wires.size()]);
        }
        ArrayList<Wire> result = new ArrayList<Wire>();
        for (ComponentRevisionImpl<C> componentRevisionImpl : componentRevisions) {
            result.addAll(componentRevisionImpl.getWiresByCapability(capability));
        }
        return result.toArray(new Wire[result.size()]);
    }

    public Wire[] getWiresByRequirement(Requirement requirement) {
        ComponentRevisionImpl<C>[] componentRevisions = this.getResources();
        if (componentRevisions.length == 0) {
            return new Wire[0];
        }
        if (componentRevisions.length == 1) {
            List<Wire> wires = componentRevisions[0].getWiresByRequirement(requirement);
            return wires.toArray(new Wire[wires.size()]);
        }
        ArrayList<Wire> result = new ArrayList<Wire>();
        for (ComponentRevisionImpl<C> componentRevisionImpl : componentRevisions) {
            result.addAll(componentRevisionImpl.getWiresByRequirement(requirement));
        }
        return result.toArray(new Wire[result.size()]);
    }

    protected void registerContainerService(Dictionary<String, Object> properties, List<String> serviceInterfaces) {
        this.unregisterService();
        this.serviceRegistration = this.bundleContext.registerService(serviceInterfaces.toArray(new String[serviceInterfaces.size()]), (Object)this, properties);
    }

    private Version resolveComponentVersion() {
        Version version = this.componentMetadata.getVersion();
        if (version != null) {
            return version;
        }
        return this.bundleContext.getBundle().getVersion();
    }

    protected void unregisterService() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }
}

