/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal.attribute;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.everit.osgi.capabilitycollector.AbstractCapabilityCollector;
import org.everit.osgi.capabilitycollector.CapabilityConsumer;
import org.everit.osgi.capabilitycollector.RequirementDefinition;
import org.everit.osgi.capabilitycollector.Suiting;
import org.everit.osgi.ecm.component.AbstractReferenceHolder;
import org.everit.osgi.ecm.component.ConfigurationException;
import org.everit.osgi.ecm.component.ri.internal.ComponentContextImpl;
import org.everit.osgi.ecm.component.ri.internal.ReferenceEventHandler;
import org.everit.osgi.ecm.metadata.MetadataValidationException;
import org.everit.osgi.ecm.metadata.ReferenceConfigurationType;
import org.everit.osgi.ecm.metadata.ReferenceMetadata;
import org.everit.osgi.ecm.util.method.MethodDescriptor;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public abstract class ReferenceHelper<CAPABILITY, COMPONENT, METADATA extends ReferenceMetadata> {
    private final boolean array;
    private final AbstractCapabilityCollector<CAPABILITY> collector;
    private final ComponentContextImpl<COMPONENT> componentContext;
    private final ReferenceEventHandler eventHandler;
    private final boolean holder;
    private Object previousInstance = null;
    private final METADATA referenceMetadata;
    private boolean satisfied = false;
    private boolean satisfiedNotificationSent = false;
    private final MethodHandle setterMethodHandle;
    private Suiting<CAPABILITY>[] suitings;

    public ReferenceHelper(METADATA referenceMetadata, ComponentContextImpl<COMPONENT> componentContext, ReferenceEventHandler eventHandler) throws IllegalAccessException {
        this.referenceMetadata = referenceMetadata;
        this.componentContext = componentContext;
        this.eventHandler = eventHandler;
        MethodDescriptor setterMethodDescriptor = referenceMetadata.getSetter();
        if (setterMethodDescriptor == null) {
            this.holder = false;
            this.setterMethodHandle = null;
            this.array = false;
        } else {
            Method setterMethod = setterMethodDescriptor.locate(componentContext.getComponentType(), false);
            if (setterMethod == null) {
                throw new MetadataValidationException("Setter method '" + setterMethodDescriptor.toString() + "' could not be found for class " + componentContext.getComponentType());
            }
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            this.setterMethodHandle = lookup.unreflect(setterMethod);
            Class<?>[] parameterTypes = setterMethod.getParameterTypes();
            if (parameterTypes.length != 1 || parameterTypes[0].isPrimitive()) {
                throw new MetadataValidationException("Setter method for reference '" + referenceMetadata.toString() + "' that is defined in the class '" + componentContext.getComponentType() + "' must have one non-primitive parameter.");
            }
            if (AbstractReferenceHolder.class.isAssignableFrom(parameterTypes[0])) {
                this.holder = true;
                this.array = false;
            } else if (parameterTypes[0].isArray()) {
                this.holder = AbstractReferenceHolder.class.isAssignableFrom(parameterTypes[0].getComponentType());
                this.array = true;
            } else {
                this.array = false;
                this.holder = false;
            }
        }
        RequirementDefinition[] requirements = new RequirementDefinition[]{};
        this.collector = this.createCollector(new ReferenceCapabilityConsumer(), requirements);
    }

    public void bind() {
        try {
            if (this.setterMethodHandle != null) {
                if (!this.array && this.suitings.length > 1) {
                    this.getComponentContext().fail((Throwable)new ConfigurationException(this.getReferenceMetadata().getAttributeId() + ": Multiple references assigned to the reference while the setter" + " method is not an array"), false);
                }
                COMPONENT instance = this.componentContext.getInstance();
                if (this.previousInstance == null || !this.previousInstance.equals(instance)) {
                    this.previousInstance = instance;
                    this.setterMethodHandle.bindTo(instance);
                }
                this.bindInternal();
            }
        }
        catch (RuntimeException e) {
            this.componentContext.fail(e, false);
        }
    }

    protected abstract void bindInternal();

    public void close() {
        this.satisfied = false;
        this.collector.close();
    }

    protected abstract AbstractCapabilityCollector<CAPABILITY> createCollector(ReferenceCapabilityConsumer var1, RequirementDefinition<CAPABILITY>[] var2);

    private RequirementDefinition<CAPABILITY>[] createRequirementDefinitionArray(int n) {
        RequirementDefinition[] result = new RequirementDefinition[n];
        return result;
    }

    private RequirementDefinition<CAPABILITY>[] emptyRequirementDefinitionsArray() {
        RequirementDefinition[] result = new RequirementDefinition[]{};
        return result;
    }

    private void failConfiguration(String message, Exception e) {
        String attributeId = this.referenceMetadata.getAttributeId();
        Map<String, Object> properties = this.componentContext.getProperties();
        String servicePid = String.valueOf(properties.get("service.pid"));
        String finalMessage = "Error in configuration of attribute '" + attributeId + "' in '" + servicePid + "': " + message;
        if (e != null) {
            this.componentContext.fail((Throwable)new ConfigurationException(finalMessage, (Throwable)e), false);
        } else {
            this.componentContext.fail((Throwable)new ConfigurationException(finalMessage), false);
        }
    }

    public abstract void free();

    private void fillAttributesOfRequirementFromClause(Map<String, Object> attributes, Clause clauses) {
        Attribute[] parsedAttributes;
        for (Attribute attribute : parsedAttributes = clauses.getAttributes()) {
            attributes.put(attribute.getName(), attribute.getValue());
        }
    }

    private RequirementDefinition<CAPABILITY>[] generateRequirementDefinitions(String[] requirementStringArray, ReferenceConfigurationType configurationType) {
        RequirementDefinition<CAPABILITY>[] result = this.createRequirementDefinitionArray(requirementStringArray.length);
        for (int i = 0; i < requirementStringArray.length; ++i) {
            String requirementString = requirementStringArray[i];
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
            String requirementId = "" + i;
            String filterString = requirementString;
            if (configurationType == ReferenceConfigurationType.CLAUSE) {
                if (requirementString == null) {
                    this.failConfiguration("Value must be defined", null);
                    return this.emptyRequirementDefinitionsArray();
                }
                try {
                    Clause[] clauses = Parser.parseClauses((String[])new String[]{requirementString});
                    if (clauses != null) {
                        this.fillAttributesOfRequirementFromClause(attributes, clauses[0]);
                        requirementId = clauses[0].getName();
                        filterString = clauses[0].getDirective("filter");
                    }
                }
                catch (IllegalArgumentException e) {
                    this.failConfiguration("Invalid clause: " + requirementString, e);
                    return this.emptyRequirementDefinitionsArray();
                }
            }
            Filter filter = null;
            if (filterString != null) {
                try {
                    filter = FrameworkUtil.createFilter((String)filterString);
                }
                catch (InvalidSyntaxException e) {
                    this.failConfiguration("Invalid OSGi filter expression: " + requirementString, (Exception)((Object)e));
                    return this.emptyRequirementDefinitionsArray();
                }
            }
            result[i] = new RequirementDefinition(requirementId, filter, attributes);
        }
        return result;
    }

    public ComponentContextImpl<COMPONENT> getComponentContext() {
        return this.componentContext;
    }

    public METADATA getReferenceMetadata() {
        return this.referenceMetadata;
    }

    public MethodHandle getSetterMethodHandle() {
        return this.setterMethodHandle;
    }

    public Suiting<CAPABILITY>[] getSuitings() {
        return (Suiting[])this.suitings.clone();
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isHolder() {
        return this.holder;
    }

    public boolean isOpened() {
        return this.collector.isOpened();
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    public void open() {
        this.updateConfiguration();
        this.collector.open();
    }

    private void replaceEmptyStringWithNullInRequirementsArray(String[] requirementStringArray) {
        for (int i = 0; i < requirementStringArray.length; ++i) {
            String requirementString = requirementStringArray[i];
            if (requirementString == null || !"".equals(requirementString.trim())) continue;
            requirementStringArray[i] = null;
        }
    }

    private RequirementDefinition<CAPABILITY>[] resolveRequirements() {
        String[] requirementStringArray;
        String attributeId = this.referenceMetadata.getAttributeId();
        Map<String, Object> properties = this.componentContext.getProperties();
        Object requirementAttribute = properties.get(attributeId);
        if (requirementAttribute == null) {
            RequirementDefinition<CAPABILITY>[] result = this.createRequirementDefinitionArray(0);
            return result;
        }
        if (requirementAttribute instanceof String) {
            requirementStringArray = new String[]{(String)requirementAttribute};
        } else if (requirementAttribute instanceof String[]) {
            requirementStringArray = (String[])requirementAttribute;
        } else {
            this.failConfiguration("Only String and String[] is accepted: " + requirementAttribute.getClass().getCanonicalName(), null);
            return this.emptyRequirementDefinitionsArray();
        }
        this.replaceEmptyStringWithNullInRequirementsArray(requirementStringArray);
        ReferenceConfigurationType configurationType = this.referenceMetadata.getReferenceConfigurationType();
        return this.generateRequirementDefinitions(requirementStringArray, configurationType);
    }

    public void updateConfiguration() {
        Object[] newRequirements = this.resolveRequirements();
        try {
            this.collector.updateRequirements(newRequirements);
        }
        catch (RuntimeException e) {
            this.failConfiguration("Cannot update requirements on tracker: " + Arrays.toString(newRequirements), e);
        }
    }

    static /* synthetic */ Suiting[] access$002(ReferenceHelper x0, Suiting[] x1) {
        x0.suitings = x1;
        return x1;
    }

    protected class ReferenceCapabilityConsumer
    implements CapabilityConsumer<CAPABILITY> {
        protected ReferenceCapabilityConsumer() {
        }

        public void accept(Suiting<CAPABILITY>[] pSuitings, boolean pSatisfied) {
            ReferenceHelper.access$002(ReferenceHelper.this, pSuitings);
            ReferenceHelper.this.satisfied = pSatisfied;
            ReferenceHelper owner = ReferenceHelper.this;
            if (pSatisfied) {
                if (!ReferenceHelper.this.satisfiedNotificationSent) {
                    ReferenceHelper.this.satisfiedNotificationSent = true;
                    ReferenceHelper.this.eventHandler.satisfied(owner);
                } else if (ReferenceHelper.this.referenceMetadata.isDynamic()) {
                    ReferenceHelper.this.eventHandler.updateDynamicWithoutSatisfactionChange(owner);
                } else {
                    ReferenceHelper.this.eventHandler.updateNonDynamic(owner);
                }
            } else if (ReferenceHelper.this.satisfiedNotificationSent) {
                ReferenceHelper.this.satisfiedNotificationSent = false;
                ReferenceHelper.this.eventHandler.unsatisfied(owner);
            } else {
                ReferenceHelper.this.eventHandler.updateDynamicWithoutSatisfactionChange(owner);
            }
        }
    }
}

