/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal.attribute;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.everit.osgi.ecm.component.ConfigurationException;
import org.everit.osgi.ecm.component.resource.ComponentState;
import org.everit.osgi.ecm.component.ri.internal.ComponentContextImpl;
import org.everit.osgi.ecm.component.ri.internal.IllegalMetadataException;
import org.everit.osgi.ecm.metadata.ComponentMetadata;
import org.everit.osgi.ecm.metadata.PropertyAttributeMetadata;
import org.everit.osgi.ecm.util.method.MethodDescriptor;

public class PropertyAttributeHelper<C, V_ARRAY> {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_BOXING_TYPE_MAPPING = new HashMap();
    private final PropertyAttributeMetadata<V_ARRAY> attributeMetadata;
    private final ComponentContextImpl<C> componentContext;
    private final MethodHandle methodHandle;

    public PropertyAttributeHelper(ComponentContextImpl<C> componentContext, PropertyAttributeMetadata<V_ARRAY> attributeMetadata) {
        this.componentContext = componentContext;
        this.attributeMetadata = attributeMetadata;
        this.methodHandle = this.resolveMethodHandle();
    }

    public void applyValue(Object newValue) {
        Object parameterValue = this.resolveValue(newValue);
        if (this.componentContext.getState() == ComponentState.FAILED) {
            return;
        }
        if (this.methodHandle != null) {
            C instance = this.componentContext.getInstance();
            this.methodHandle.bindTo(instance);
            try {
                this.methodHandle.invoke(instance, parameterValue);
            }
            catch (Throwable e) {
                this.componentContext.fail(e, false);
            }
        }
    }

    private void failDuringValueResolution(String message) {
        Map<String, Object> properties = this.componentContext.getProperties();
        String servicePid = (String)properties.get("service.pid");
        ComponentMetadata componentMetadata = this.componentContext.getComponentContainer().getComponentMetadata();
        if (servicePid == null) {
            servicePid = componentMetadata.getComponentId();
        }
        ConfigurationException e = new ConfigurationException("Error during updating configuration of component '" + servicePid + "' declared in class '" + componentMetadata.getType() + "': " + message);
        this.componentContext.fail((Throwable)e, false);
    }

    public PropertyAttributeMetadata<V_ARRAY> getAttributeMetadata() {
        return this.attributeMetadata;
    }

    private MethodHandle resolveMethodHandle() {
        Method setter = this.resolveSetter();
        if (setter == null) {
            return null;
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.unreflect(setter);
        }
        catch (IllegalAccessException e) {
            this.componentContext.fail(e, true);
            return null;
        }
    }

    private Object resolveMultiValue(Object valueObject, Class<? extends Object> valueClass, Class<?> attributeType) {
        if (!valueClass.isArray()) {
            this.failDuringValueResolution("An array was expected as value for attribute '" + this.attributeMetadata.getAttributeId() + "' but got '" + valueClass.getCanonicalName() + '\'');
            return null;
        }
        Class<?> componentType = valueClass.getComponentType();
        if (!attributeType.equals(componentType)) {
            StringBuilder sb = new StringBuilder();
            sb.append("'").append(attributeType).append("[]' was expected for attribute '").append(this.attributeMetadata.getAttributeId()).append("' but got '").append(componentType).append("'");
            this.failDuringValueResolution(sb.toString());
            return null;
        }
        return valueObject;
    }

    private Method resolveSetter() {
        MethodDescriptor setterMethodDescriptor = this.attributeMetadata.getSetter();
        if (setterMethodDescriptor == null) {
            return null;
        }
        Method method = setterMethodDescriptor.locate(this.componentContext.getComponentType(), false);
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            this.throwIllegalSetter(method, "Setter method must have one parameter: " + method.toGenericString());
            return null;
        }
        if (this.attributeMetadata.isMultiple()) {
            if (!parameterTypes[0].isArray()) {
                this.throwIllegalSetter(method, "Parameter type should be an array");
                return null;
            }
            Class<?> componentType = parameterTypes[0].getComponentType();
            Class expectedComponentType = this.attributeMetadata.getValueType();
            if (!expectedComponentType.equals(componentType)) {
                this.throwIllegalSetter(method, "Parameter array should have '" + expectedComponentType + "' component type.");
                return null;
            }
        } else {
            Class valueType = this.attributeMetadata.getValueType();
            if (!valueType.equals(parameterTypes[0])) {
                if (valueType.isPrimitive()) {
                    Class<?> boxingType = PRIMITIVE_BOXING_TYPE_MAPPING.get(valueType);
                    if (!boxingType.equals(parameterTypes[0])) {
                        this.throwIllegalSetter(method, " Parameter should be " + valueType.getCanonicalName() + " or " + boxingType.getCanonicalName() + ": " + method.toGenericString());
                    }
                } else {
                    this.throwIllegalSetter(method, " Parameter type should be " + valueType.getCanonicalName() + ": " + method.toGenericString());
                }
            }
        }
        return method;
    }

    private Object resolveSimpleValue(Object valueObject, Class<? extends Object> valueClass, Class<?> attributeType) {
        Object simpleValue = valueObject;
        Class<Object> simpleValueClass = valueClass;
        if (valueClass.isArray()) {
            int length = Array.getLength(valueObject);
            if (length == 0) {
                if (!this.attributeMetadata.isOptional()) {
                    this.failDuringValueResolution("Mandatory non-array attribute '" + this.attributeMetadata.getAttributeId() + "' cannot be specified with an empty array.");
                }
                return null;
            }
            if (length == 1) {
                simpleValue = Array.get(valueObject, 0);
                simpleValueClass = simpleValue.getClass();
            }
        }
        if (!(simpleValueClass.equals(attributeType) || attributeType.isPrimitive() && PRIMITIVE_BOXING_TYPE_MAPPING.get(attributeType).equals(simpleValueClass))) {
            StringBuilder sb = new StringBuilder("Either ");
            if (attributeType.isPrimitive()) {
                sb.append(PRIMITIVE_BOXING_TYPE_MAPPING.get(attributeType).getCanonicalName()).append(" or ");
            }
            sb.append(attributeType.getCanonicalName()).append(" was expected for attribute '").append(this.attributeMetadata.getAttributeId()).append("' but got ").append(valueClass.getCanonicalName());
            this.failDuringValueResolution(sb.toString());
            return null;
        }
        return simpleValue;
    }

    private Object resolveValue(Object valueObject) {
        if (valueObject == null) {
            if (!this.attributeMetadata.isOptional()) {
                this.failDuringValueResolution("Mandatory attribute '" + this.attributeMetadata.getAttributeId() + "' is not specified");
            }
            return null;
        }
        Class<?> valueClass = valueObject.getClass();
        Class attributeType = this.attributeMetadata.getValueType();
        if (this.attributeMetadata.isMultiple()) {
            return this.resolveMultiValue(valueObject, valueClass, attributeType);
        }
        return this.resolveSimpleValue(valueObject, valueClass, attributeType);
    }

    private void throwIllegalSetter(Method method, String additionalMessage) {
        IllegalMetadataException e = new IllegalMetadataException("Invalid setter '" + method.toGenericString() + "' defined for attribute '" + this.attributeMetadata.getAttributeId() + "' of component '" + this.componentContext.getComponentContainer().getComponentMetadata().getComponentId() + "'. " + additionalMessage);
        this.componentContext.fail(e, true);
    }

    static {
        PRIMITIVE_BOXING_TYPE_MAPPING.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_BOXING_TYPE_MAPPING.put(Byte.TYPE, Byte.class);
        PRIMITIVE_BOXING_TYPE_MAPPING.put(Character.TYPE, Character.class);
        PRIMITIVE_BOXING_TYPE_MAPPING.put(Double.TYPE, Double.class);
        PRIMITIVE_BOXING_TYPE_MAPPING.put(Float.TYPE, Float.class);
        PRIMITIVE_BOXING_TYPE_MAPPING.put(Integer.TYPE, Integer.class);
        PRIMITIVE_BOXING_TYPE_MAPPING.put(Long.TYPE, Long.class);
        PRIMITIVE_BOXING_TYPE_MAPPING.put(Short.TYPE, Short.class);
    }
}

