/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.everit.osgi.ecm.component.resource.ComponentContainer;
import org.everit.osgi.ecm.component.ri.internal.AbstractComponentContainer;
import org.everit.osgi.ecm.component.ri.internal.ComponentContextImpl;
import org.everit.osgi.ecm.component.ri.internal.resource.ComponentRevisionImpl;
import org.everit.osgi.ecm.metadata.ComponentMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.MetaTypeProvider;

public class FactoryComponentContainerImpl<C>
extends AbstractComponentContainer<C>
implements ManagedServiceFactory {
    private final Map<String, ComponentContextImpl<C>> components = new ConcurrentHashMap<String, ComponentContextImpl<C>>();
    private ServiceRegistration<?> serviceRegistration;

    public FactoryComponentContainerImpl(ComponentMetadata componentMetadata, BundleContext bundleContext, LogService logService) {
        super(componentMetadata, bundleContext, logService);
    }

    @Override
    public void close() {
        Iterator<Map.Entry<String, ComponentContextImpl<C>>> iterator = this.components.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ComponentContextImpl<C>> entry = iterator.next();
            ComponentContextImpl<C> componentContextImpl = entry.getValue();
            componentContextImpl.close();
            iterator.remove();
        }
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    public void deleted(String pid) {
        ComponentContextImpl<C> component = this.components.get(pid);
        if (component != null) {
            component.close();
            this.components.remove(pid);
        }
    }

    public String getName() {
        return this.getComponentMetadata().getComponentId();
    }

    @Override
    public ComponentRevisionImpl<C>[] getResources() {
        Collection<ComponentContextImpl<C>> values = this.components.values();
        ComponentRevisionImpl[] result = new ComponentRevisionImpl[values.size()];
        int i = 0;
        for (ComponentContextImpl<C> componentContextImpl : values) {
            result[i] = componentContextImpl.getComponentRevision();
            ++i;
        }
        return result;
    }

    @Override
    public void open() {
        BundleContext context = this.getBundleContext();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        LinkedList<String> serviceInterfaces = new LinkedList<String>();
        serviceInterfaces.add(ComponentContainer.class.getName());
        ComponentMetadata componentMetadata = this.getComponentMetadata();
        if (componentMetadata.isMetatype()) {
            ((Dictionary)properties).put("metatype.factory.pid", componentMetadata.getConfigurationPid());
            serviceInterfaces.add(MetaTypeProvider.class.getName());
        }
        this.addCommonServiceProperties(properties);
        ((Dictionary)properties).put("service.pid", componentMetadata.getConfigurationPid());
        serviceInterfaces.add(ManagedServiceFactory.class.getName());
        this.serviceRegistration = context.registerService(serviceInterfaces.toArray(new String[serviceInterfaces.size()]), (Object)this, properties);
    }

    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        Dictionary<String, Object> props = properties;
        ComponentContextImpl<C> componentContextImpl = this.components.get(pid);
        if (componentContextImpl != null) {
            componentContextImpl.updateConfiguration(properties);
        } else {
            ComponentContextImpl newComponent = new ComponentContextImpl(this, this.getBundleContext(), props, this.getLogService());
            this.components.put(pid, newComponent);
            newComponent.open();
        }
    }
}

