/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal.metatype;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import org.everit.osgi.ecm.component.ri.internal.metatype.AttributeDefinitionImpl;
import org.everit.osgi.ecm.component.ri.internal.metatype.Localizer;
import org.everit.osgi.ecm.metadata.AttributeMetadata;
import org.everit.osgi.ecm.metadata.AttributeMetadataHolder;
import org.everit.osgi.ecm.metadata.ComponentMetadata;
import org.everit.osgi.ecm.metadata.Icon;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class ObjectClassDefinitionImpl<C>
implements ObjectClassDefinition {
    private final AttributeDefinition[] attributeDefinitions;
    private final ClassLoader classLoader;
    private final ComponentMetadata componentMetadata;
    private final Localizer localizer;

    public ObjectClassDefinitionImpl(ComponentMetadata componentMetadata, Localizer localizer, ClassLoader classLoader) {
        this.componentMetadata = componentMetadata;
        this.localizer = localizer;
        this.classLoader = classLoader;
        this.attributeDefinitions = this.createAttributeDefinitions(componentMetadata);
    }

    private AttributeDefinition[] createAttributeDefinitions(ComponentMetadata pComponentMetadata) {
        AttributeMetadata[] attributes = pComponentMetadata.getAttributes();
        if (attributes == null || attributes.length == 0) {
            return this.noAttributeDefinitions();
        }
        LinkedList result = new LinkedList();
        for (AttributeMetadata attribute : attributes) {
            AttributeDefinitionImpl attributeDefinition = new AttributeDefinitionImpl(attribute, this.localizer);
            result.add(attributeDefinition);
        }
        if (result.size() == 0) {
            return this.noAttributeDefinitions();
        }
        return result.toArray(new AttributeDefinition[result.size()]);
    }

    private AttributeDefinition[] generateAttributeDefinitions(boolean required) {
        ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>();
        for (AttributeDefinition ad : this.attributeDefinitions) {
            AttributeMetadataHolder amh = (AttributeMetadataHolder)ad;
            AttributeMetadata attributeMetadata = amh.getMetadata();
            if ((!required || attributeMetadata.isOptional()) && (required || !attributeMetadata.isOptional())) continue;
            result.add(ad);
        }
        if (result.size() == 0) {
            return this.noAttributeDefinitions();
        }
        return result.toArray(new AttributeDefinition[result.size()]);
    }

    public AttributeDefinition[] getAttributeDefinitions(int filter) {
        if (this.attributeDefinitions == null) {
            return (AttributeDefinition[])this.returnNull();
        }
        if (filter == 1) {
            return this.generateAttributeDefinitions(true);
        }
        if (filter == 2) {
            return this.generateAttributeDefinitions(false);
        }
        return (AttributeDefinition[])this.attributeDefinitions.clone();
    }

    public String getDescription() {
        return this.localizer.localize(this.componentMetadata.getDescription());
    }

    public InputStream getIcon(int size) throws IOException {
        Icon[] icons = this.componentMetadata.getIcons();
        if (icons == null || icons.length == 0) {
            return null;
        }
        int difference = Integer.MAX_VALUE;
        Icon selectedIcon = null;
        for (Icon icon : icons) {
            int currentDifference = Math.abs(size - icon.getSize());
            if (currentDifference >= difference) continue;
            selectedIcon = icon;
        }
        String iconPath = this.localizer.localize(selectedIcon.getPath());
        if (iconPath != null) {
            this.classLoader.getResourceAsStream(iconPath);
            return null;
        }
        return null;
    }

    public String getID() {
        return this.componentMetadata.getConfigurationPid();
    }

    public String getName() {
        return this.localizer.localize(this.componentMetadata.getLabel());
    }

    private AttributeDefinition[] noAttributeDefinitions() {
        AttributeDefinition[] noAttributeDefinitions = null;
        return noAttributeDefinitions;
    }

    private <N> N returnNull() {
        return null;
    }
}

