/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import org.everit.osgi.ecm.component.resource.ComponentContainer;
import org.everit.osgi.ecm.component.ri.internal.AbstractComponentContainer;
import org.everit.osgi.ecm.component.ri.internal.ComponentContextImpl;
import org.everit.osgi.ecm.component.ri.internal.resource.ComponentRevisionImpl;
import org.everit.osgi.ecm.metadata.ComponentMetadata;
import org.everit.osgi.ecm.metadata.ConfigurationPolicy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.MetaTypeProvider;

public class ComponentContainerImpl<C>
extends AbstractComponentContainer<C>
implements ManagedService {
    private final AtomicReference<ComponentContextImpl<C>> componentAtomicReference = new AtomicReference();
    private ServiceRegistration<?> serviceRegistration;

    public ComponentContainerImpl(ComponentMetadata componentMetadata, BundleContext bundleContext, LogService logService) {
        super(componentMetadata, bundleContext, logService);
    }

    @Override
    public void close() {
        ComponentContextImpl<C> componentImpl = this.componentAtomicReference.get();
        if (componentImpl != null && this.getComponentMetadata().getConfigurationPolicy() == ConfigurationPolicy.IGNORE) {
            componentImpl.close();
            this.componentAtomicReference.set(null);
        }
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    @Override
    public ComponentRevisionImpl<C>[] getResources() {
        ComponentContextImpl<C> componentImpl = this.componentAtomicReference.get();
        if (componentImpl == null) {
            ComponentRevisionImpl[] result = new ComponentRevisionImpl[]{};
            return result;
        }
        ComponentRevisionImpl[] result = new ComponentRevisionImpl[]{componentImpl.getComponentRevision()};
        return result;
    }

    @Override
    public void open() {
        BundleContext context = this.getBundleContext();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        LinkedList<String> serviceInterfaces = new LinkedList<String>();
        serviceInterfaces.add(ComponentContainer.class.getName());
        ComponentMetadata componentMetadata = this.getComponentMetadata();
        this.addCommonServiceProperties(properties);
        if (!ConfigurationPolicy.IGNORE.equals((Object)componentMetadata.getConfigurationPolicy())) {
            if (componentMetadata.isMetatype()) {
                ((Dictionary)properties).put("metatype.pid", componentMetadata.getConfigurationPid());
                serviceInterfaces.add(MetaTypeProvider.class.getName());
            }
            ((Dictionary)properties).put("service.pid", componentMetadata.getConfigurationPid());
            serviceInterfaces.add(ManagedService.class.getName());
        }
        this.serviceRegistration = context.registerService(serviceInterfaces.toArray(new String[serviceInterfaces.size()]), (Object)this, properties);
        ComponentContextImpl<C> componentImpl = this.componentAtomicReference.get();
        if (ConfigurationPolicy.IGNORE.equals((Object)componentMetadata.getConfigurationPolicy()) && componentImpl == null) {
            componentImpl = new ComponentContextImpl(this, this.getBundleContext(), null, this.getLogService());
            this.componentAtomicReference.set(componentImpl);
            componentImpl.open();
            return;
        }
    }

    public synchronized void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        Dictionary<String, Object> props = properties;
        ComponentMetadata componentMetadata = this.getComponentMetadata();
        ComponentContextImpl<C> componentImpl = this.componentAtomicReference.get();
        ConfigurationPolicy configurationPolicy = componentMetadata.getConfigurationPolicy();
        if (componentImpl == null && (properties != null || ConfigurationPolicy.OPTIONAL.equals((Object)configurationPolicy))) {
            componentImpl = new ComponentContextImpl(this, this.getBundleContext(), props, this.getLogService());
            this.componentAtomicReference.set(componentImpl);
            componentImpl.open();
        } else if (componentImpl != null && properties == null && !ConfigurationPolicy.OPTIONAL.equals((Object)configurationPolicy)) {
            componentImpl.close();
            this.componentAtomicReference.set(null);
        } else if (componentImpl != null) {
            Dictionary<String, Object> propertiesWithObjectGenerics = properties;
            componentImpl.updateConfiguration(propertiesWithObjectGenerics);
        }
    }
}

