/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.component.ri.internal.ComponentContextImpl;
import org.everit.osgi.ecm.component.ri.internal.IllegalMetadataException;
import org.everit.osgi.ecm.metadata.ComponentMetadata;
import org.everit.osgi.ecm.metadata.MetadataValidationException;
import org.everit.osgi.ecm.util.method.MethodDescriptor;
import org.everit.osgi.ecm.util.method.MethodUtil;
import org.osgi.framework.BundleContext;

public class ActivateMethodHelper<C> {
    private static final int MAX_ACTIVATE_METHOD_PARAM_NUM = 3;
    private final ComponentContextImpl<C> componentContext;
    private int indexOfBundleContextParameter = -1;
    private int indexOfComponentContextParameter = -1;
    private int indexOfPropertiesParameter = -1;
    private Method method = null;

    public ActivateMethodHelper(ComponentContextImpl<C> componentContext) {
        this.componentContext = componentContext;
        Class<C> componentType = componentContext.getComponentType();
        ComponentMetadata componentMetadata = componentContext.getComponentContainer().getComponentMetadata();
        MethodDescriptor methodDescriptor = componentMetadata.getActivate();
        if (methodDescriptor == null) {
            return;
        }
        String methodName = methodDescriptor.getMethodName();
        Method locatedMethod = null;
        if (methodDescriptor.getParameterTypeNames() != null) {
            locatedMethod = methodDescriptor.locate(componentType, false);
            if (!this.validateMethod(locatedMethod)) {
                IllegalMetadataException e = new IllegalMetadataException("Invalid activate method: " + locatedMethod.toGenericString());
                componentContext.fail(e, true);
                return;
            }
        } else {
            locatedMethod = new MethodDescriptor(methodName, new String[]{ComponentContext.class.getName()}).locate(componentType, false);
            if (locatedMethod == null) {
                locatedMethod = new MethodDescriptor(methodName, new String[]{BundleContext.class.getName()}).locate(componentType, false);
            }
            if (locatedMethod == null) {
                locatedMethod = new MethodDescriptor(methodName, new String[]{Map.class.getName()}).locate(componentType, false);
            }
            if (locatedMethod == null) {
                locatedMethod = this.locateMethodWithMinTwoParams(componentType);
            }
            if (locatedMethod == null) {
                locatedMethod = new MethodDescriptor(methodName, new String[0]).locate(componentType, false);
            }
        }
        if (locatedMethod == null) {
            MetadataValidationException e = new MetadataValidationException("Could not find activate method for component '" + componentMetadata.getComponentId() + " based on descriptor: " + methodDescriptor.toString());
            componentContext.fail((Throwable)e, true);
            return;
        }
        this.method = locatedMethod;
        this.initializeParameterIndexes();
    }

    public void call(Object instance) throws IllegalAccessException, InvocationTargetException {
        if (this.method == null) {
            return;
        }
        int paramNum = this.method.getParameterTypes().length;
        Object[] parameters = new Object[paramNum];
        if (paramNum > 0) {
            if (this.indexOfBundleContextParameter >= 0) {
                parameters[this.indexOfBundleContextParameter] = this.componentContext.getBundleContext();
            }
            if (this.indexOfComponentContextParameter >= 0) {
                parameters[this.indexOfComponentContextParameter] = this.componentContext;
            }
            if (this.indexOfPropertiesParameter >= 0) {
                parameters[this.indexOfPropertiesParameter] = this.componentContext.getProperties();
            }
        }
        this.method.invoke(instance, parameters);
    }

    private void initializeParameterIndexes() {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (parameterType.equals(ComponentContext.class)) {
                this.indexOfComponentContextParameter = i;
                continue;
            }
            if (parameterType.equals(BundleContext.class)) {
                this.indexOfBundleContextParameter = i;
                continue;
            }
            if (Map.class.isAssignableFrom(parameterType)) {
                this.indexOfPropertiesParameter = i;
                continue;
            }
            this.componentContext.fail((Throwable)new MetadataValidationException("Unrecognized type in Activate method: " + parameterType), true);
        }
    }

    private Method locateMethodWithMinTwoParams(Class<?> clazz) {
        Method foundMethod = null;
        for (Class<?> currentClass = clazz; currentClass != null && foundMethod == null; currentClass = currentClass.getSuperclass()) {
            Method[] declaredMethods = currentClass.getDeclaredMethods();
            for (int i = 0; i < declaredMethods.length && foundMethod == null; ++i) {
                Method declaredMethod = declaredMethods[i];
                Class<?>[] parameterTypes = this.method.getParameterTypes();
                int parameterNum = parameterTypes.length;
                if (!MethodUtil.isMethodAccessibleFromClass(clazz, (Method)declaredMethod, (boolean)false) || parameterNum < 2 || parameterNum > 3 || !this.validateMethod(declaredMethod)) continue;
                foundMethod = declaredMethod;
            }
        }
        return foundMethod;
    }

    private boolean validateMethod(Method pMethod) {
        Class<?>[] parameterTypes = pMethod.getParameterTypes();
        if (parameterTypes.length > 3) {
            return false;
        }
        HashSet collectedParameterTypes = new HashSet();
        for (Class<?> parameterType : parameterTypes) {
            if (!(parameterType.equals(ComponentContext.class) || parameterType.equals(Map.class) || parameterType.equals(BundleContext.class))) {
                return false;
            }
            boolean added = collectedParameterTypes.add(parameterType);
            if (added) continue;
            return false;
        }
        return true;
    }
}

