/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri;

import org.everit.osgi.ecm.component.ri.ComponentContainerInstance;
import org.everit.osgi.ecm.component.ri.internal.ComponentContainerImpl;
import org.everit.osgi.ecm.component.ri.internal.FactoryComponentContainerImpl;
import org.everit.osgi.ecm.component.ri.internal.JavaLogService;
import org.everit.osgi.ecm.metadata.ComponentMetadata;
import org.everit.osgi.ecm.metadata.ConfigurationPolicy;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class ComponentContainerFactory {
    private final BundleContext bundleContext;
    private final LogService logService;

    public ComponentContainerFactory(BundleContext bundleContex) {
        this(bundleContex, null);
    }

    public ComponentContainerFactory(BundleContext bundleContext, LogService logService) {
        this.bundleContext = bundleContext;
        this.logService = logService != null ? logService : new JavaLogService();
    }

    public <C> ComponentContainerInstance<C> createComponentContainer(ComponentMetadata componentMetadata) {
        if (ConfigurationPolicy.FACTORY.equals((Object)componentMetadata.getConfigurationPolicy())) {
            return new FactoryComponentContainerImpl(componentMetadata, this.bundleContext, this.logService);
        }
        return new ComponentContainerImpl(componentMetadata, this.bundleContext, this.logService);
    }
}

