/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.everit.osgi.linkage.ServiceCapability;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleRevision;

public class ServiceCapabilityImpl
implements ServiceCapability {
    private final Map<String, Object> attributes;
    private final BundleRevision resource;
    private final ServiceReference<?> serviceReference;

    public ServiceCapabilityImpl(ServiceReference<?> serviceReference) {
        String[] propertyKeys;
        this.serviceReference = serviceReference;
        this.resource = (BundleRevision)serviceReference.getBundle().adapt(BundleRevision.class);
        HashMap<String, Object> serviceProps = new HashMap<String, Object>();
        for (String propertyKey : propertyKeys = serviceReference.getPropertyKeys()) {
            serviceProps.put(propertyKey, serviceReference.getProperty(propertyKey));
        }
        this.attributes = Collections.unmodifiableMap(serviceProps);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceCapabilityImpl other = (ServiceCapabilityImpl)obj;
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return !(this.serviceReference == null ? other.serviceReference != null : !this.serviceReference.equals(other.serviceReference));
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getDirectives() {
        return Collections.emptyMap();
    }

    public String getNamespace() {
        return "osgi.service";
    }

    public BundleRevision getResource() {
        return this.resource;
    }

    public ServiceReference<?> getServiceReference() {
        return this.serviceReference;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.serviceReference == null ? 0 : this.serviceReference.hashCode());
        return result;
    }
}

