/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal.metatype;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import org.everit.osgi.ecm.component.ri.internal.metatype.Localizer;
import org.everit.osgi.ecm.component.ri.internal.metatype.ObjectClassDefinitionImpl;
import org.everit.osgi.ecm.metadata.ComponentMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class MetatypeProviderImpl<C>
implements MetaTypeProvider {
    private static final String LOCALE_SEPARATOR = "_";
    private final BundleContext bundleContext;
    private final ComponentMetadata componentMetadata;
    private final String[] locales;

    public MetatypeProviderImpl(ComponentMetadata componentMetadata, BundleContext bundleContext) {
        this.componentMetadata = componentMetadata;
        this.bundleContext = bundleContext;
        this.locales = this.createLocales();
    }

    private <T> T[] cloneIfNotNull(T[] original) {
        if (original == null) {
            T[] undefinedValue = null;
            return undefinedValue;
        }
        return (Object[])original.clone();
    }

    private String[] createLocales() {
        String localizationBase = this.componentMetadata.getLocalizationBase();
        if (localizationBase == null) {
            return (String[])this.cloneIfNotNull(null);
        }
        int lastIndexOfSlash = localizationBase.lastIndexOf(47);
        String path = localizationBase;
        String filePattern = localizationBase;
        if (lastIndexOfSlash > 0) {
            path = localizationBase.substring(0, lastIndexOfSlash);
            filePattern = filePattern.substring(lastIndexOfSlash + 1);
        }
        Bundle bundle = this.bundleContext.getBundle();
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        String propertiesPattern = "*.properties";
        Collection resources = bundleWiring.listResources(path, filePattern + propertiesPattern, 2);
        if (resources.size() == 0) {
            return (String[])this.cloneIfNotNull(null);
        }
        int localizationBaseLength = localizationBase.length();
        HashSet<String> result = new HashSet<String>();
        int propertiesExtensionLength = propertiesPattern.length() - 1;
        for (String resource : resources) {
            String locale = resource.substring(localizationBaseLength, resource.length() - propertiesExtensionLength);
            if (locale.length() == 0) {
                result.add("");
                continue;
            }
            if (!locale.startsWith(LOCALE_SEPARATOR)) continue;
            result.add(locale.substring(1));
        }
        if (result.size() == 0) {
            return (String[])this.cloneIfNotNull(null);
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getLocales() {
        return this.cloneIfNotNull(this.locales);
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String localeString) {
        Localizer localizer;
        BundleWiring bundleWiring = (BundleWiring)this.bundleContext.getBundle().adapt(BundleWiring.class);
        ClassLoader classLoader = bundleWiring.getClassLoader();
        String localizationBase = this.componentMetadata.getLocalizationBase();
        if (this.locales == null) {
            localizer = new Localizer(null);
        } else {
            String[] localeParts;
            Locale locale = localeString == null ? Locale.getDefault() : ((localeParts = localeString.split(LOCALE_SEPARATOR)).length == 1 ? new Locale(localeParts[0]) : (localeParts.length == 2 ? new Locale(localeParts[0], localeParts[1]) : new Locale(localeParts[0], localeParts[1], localeParts[2])));
            localizer = new Localizer(ResourceBundle.getBundle(localizationBase, locale, classLoader));
        }
        ObjectClassDefinitionImpl objectClassDefinition = new ObjectClassDefinitionImpl(this.componentMetadata, localizer, classLoader);
        return objectClassDefinition;
    }
}

