/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal.metatype;

import java.lang.reflect.Array;
import org.everit.osgi.ecm.component.ri.internal.metatype.Localizer;
import org.everit.osgi.ecm.metadata.AttributeMetadata;
import org.everit.osgi.ecm.metadata.AttributeMetadataHolder;
import org.everit.osgi.ecm.metadata.PasswordAttributeMetadata;
import org.everit.osgi.ecm.metadata.SelectablePropertyAttributeMetadata;
import org.osgi.service.metatype.AttributeDefinition;

public class AttributeDefinitionImpl<V_ARRAY>
implements AttributeDefinition,
AttributeMetadataHolder<V_ARRAY> {
    private final AttributeMetadata<V_ARRAY> attributeMetadata;
    private final int attributeType;
    private final String[] defaultValue;
    private final Localizer localizer;
    private final String[] optionLabels;
    private final String[] optionValues;

    public AttributeDefinitionImpl(AttributeMetadata<V_ARRAY> attributeMetadata, Localizer localizer) {
        this.attributeMetadata = attributeMetadata;
        this.localizer = localizer;
        Class valueType = attributeMetadata.getValueType();
        this.attributeType = this.convertValueTypeToAttributeType(valueType);
        this.defaultValue = this.createDefaultValueArray();
        if (attributeMetadata instanceof SelectablePropertyAttributeMetadata) {
            SelectablePropertyAttributeMetadata selectableMetadata = (SelectablePropertyAttributeMetadata)attributeMetadata;
            String[] tmpOptionLabels = selectableMetadata.getOptionLabels();
            Object tmpOptionValues = selectableMetadata.getOptionValues();
            if (tmpOptionValues == null) {
                this.optionValues = null;
                this.optionLabels = null;
            } else {
                int length = Array.getLength(tmpOptionValues);
                this.optionLabels = tmpOptionLabels == null ? null : new String[length];
                this.optionValues = new String[length];
                for (int i = 0; i < length; ++i) {
                    Object optionValue = Array.get(tmpOptionValues, i);
                    if (optionValue != null) {
                        this.optionValues[i] = String.valueOf(optionValue);
                    }
                    if (this.optionLabels == null) continue;
                    this.optionLabels[i] = tmpOptionLabels[i] != null ? localizer.localize(tmpOptionLabels[i]) : this.optionValues[i];
                }
            }
        } else {
            this.optionLabels = null;
            this.optionValues = null;
        }
    }

    private <T> T[] cloneIfNotNull(T[] original) {
        if (original == null) {
            T[] undefinedValue = null;
            return undefinedValue;
        }
        return (Object[])original.clone();
    }

    private int convertValueTypeToAttributeType(Class<?> valueType) {
        if (Boolean.TYPE.equals(valueType)) {
            return 11;
        }
        if (Byte.TYPE.equals(valueType)) {
            return 6;
        }
        if (Character.TYPE.equals(valueType)) {
            return 5;
        }
        if (Double.TYPE.equals(valueType)) {
            return 7;
        }
        if (Float.TYPE.equals(valueType)) {
            return 8;
        }
        if (Integer.TYPE.equals(valueType)) {
            return 3;
        }
        if (Long.TYPE.equals(valueType)) {
            return 2;
        }
        if (Short.TYPE.equals(valueType)) {
            return 4;
        }
        if (this.attributeMetadata.getClass().equals(PasswordAttributeMetadata.class)) {
            return 12;
        }
        return 1;
    }

    private String[] createDefaultValueArray() {
        Object tmpDefaultValue = this.attributeMetadata.getDefaultValue();
        if (tmpDefaultValue == null) {
            return (String[])this.cloneIfNotNull(null);
        }
        int length = Array.getLength(tmpDefaultValue);
        if (length == 0) {
            return (String[])this.cloneIfNotNull(null);
        }
        String[] result = new String[length];
        for (int i = 0; i < result.length; ++i) {
            Object element = Array.get(tmpDefaultValue, i);
            if (element == null) continue;
            result[i] = String.valueOf(element);
        }
        return result;
    }

    public int getCardinality() {
        if (this.attributeMetadata.isMultiple()) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    public String[] getDefaultValue() {
        return this.cloneIfNotNull(this.defaultValue);
    }

    public String getDescription() {
        return this.localizer.localize(this.attributeMetadata.getDescription());
    }

    public String getID() {
        return this.attributeMetadata.getAttributeId();
    }

    public AttributeMetadata<V_ARRAY> getMetadata() {
        return this.attributeMetadata;
    }

    public String getName() {
        return this.localizer.localize(this.attributeMetadata.getLabel());
    }

    public String[] getOptionLabels() {
        return this.cloneIfNotNull(this.optionLabels);
    }

    public String[] getOptionValues() {
        return this.cloneIfNotNull(this.optionValues);
    }

    public int getType() {
        return this.attributeType;
    }

    public String validate(String value) {
        return null;
    }
}

