/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.component.ri.internal;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.component.resource.ComponentContainer;
import org.everit.osgi.ecm.component.resource.ComponentState;
import org.everit.osgi.ecm.component.ri.internal.AbstractComponentContainer;
import org.everit.osgi.ecm.component.ri.internal.ActivateMethodHelper;
import org.everit.osgi.ecm.component.ri.internal.ComponentServiceRegistration;
import org.everit.osgi.ecm.component.ri.internal.IllegalMetadataException;
import org.everit.osgi.ecm.component.ri.internal.ReferenceEventHandler;
import org.everit.osgi.ecm.component.ri.internal.attribute.BundleCapabilityReferenceAttributeHelper;
import org.everit.osgi.ecm.component.ri.internal.attribute.PropertyAttributeHelper;
import org.everit.osgi.ecm.component.ri.internal.attribute.ReferenceHelper;
import org.everit.osgi.ecm.component.ri.internal.attribute.ServiceReferenceAttributeHelper;
import org.everit.osgi.ecm.component.ri.internal.resource.ComponentRevisionImpl;
import org.everit.osgi.ecm.metadata.AttributeMetadata;
import org.everit.osgi.ecm.metadata.BundleCapabilityReferenceMetadata;
import org.everit.osgi.ecm.metadata.ComponentMetadata;
import org.everit.osgi.ecm.metadata.PropertyAttributeMetadata;
import org.everit.osgi.ecm.metadata.ReferenceMetadata;
import org.everit.osgi.ecm.metadata.ServiceMetadata;
import org.everit.osgi.ecm.metadata.ServiceReferenceMetadata;
import org.everit.osgi.ecm.util.method.MethodDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;

public class ComponentContextImpl<C>
implements ComponentContext<C> {
    private ActivateMethodHelper<C> activateMethodHelper;
    private final BundleContext bundleContext;
    private final AbstractComponentContainer<C> componentContainer;
    private Class<C> componentType;
    private boolean configurationUpdateInProgress = false;
    private Method deactivateMethod;
    private C instance;
    private boolean opened = false;
    private final List<PropertyAttributeHelper<C, Object>> propertyAttributeHelpers = new ArrayList<PropertyAttributeHelper<C, Object>>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReferenceEventHandler referenceEventHandler = new ReferenceEventHandlerImpl();
    private final List<ReferenceHelper<?, C, ?>> referenceHelpers = new ArrayList();
    private final ComponentRevisionImpl.Builder<C> revisionBuilder;
    private int satisfiedReferences = 0;
    private String[] serviceInterfaces;
    private ServiceRegistration<?> serviceRegistration = null;
    private Method updateMethod;

    private static void resolveSuperInterfacesRecurse(Class<?> currentClass, Set<String> interfaces) {
        Class<?>[] superInterfaces;
        for (Class<?> superInterface : superInterfaces = currentClass.getInterfaces()) {
            interfaces.add(superInterface.getName());
            ComponentContextImpl.resolveSuperInterfacesRecurse(superInterface, interfaces);
        }
    }

    public ComponentContextImpl(AbstractComponentContainer<C> componentContainer, BundleContext bundleContext) {
        this(componentContainer, bundleContext, null);
    }

    public ComponentContextImpl(AbstractComponentContainer<C> componentContainer, BundleContext bundleContext, Dictionary<String, Object> properties) {
        this.bundleContext = bundleContext;
        this.componentContainer = componentContainer;
        this.revisionBuilder = new ComponentRevisionImpl.Builder<C>(componentContainer, this.resolveProperties(properties));
        if (this.isFailed()) {
            return;
        }
        ComponentMetadata componentMetadata = componentContainer.getComponentMetadata();
        Bundle bundle = bundleContext.getBundle();
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        ClassLoader classLoader = bundleWiring.getClassLoader();
        try {
            Class<?> tmpComponentType = classLoader.loadClass(componentMetadata.getType());
            this.componentType = tmpComponentType;
        }
        catch (ClassNotFoundException e) {
            this.fail(e, true);
            return;
        }
        this.activateMethodHelper = new ActivateMethodHelper(this);
        if (this.isFailed()) {
            return;
        }
        AttributeMetadata[] attributes = componentMetadata.getAttributes();
        this.fillAttributeHelpers(attributes);
        this.serviceInterfaces = this.resolveServiceInterfaces();
        this.deactivateMethod = this.resolveAnnotatedMethod("deactivate", componentContainer.getComponentMetadata().getDeactivate());
        this.updateMethod = this.resolveAnnotatedMethod("update", componentContainer.getComponentMetadata().getUpdate());
    }

    private void callUpdateMethod() {
        if (this.updateMethod != null) {
            try {
                this.updateMethod.invoke(this.instance, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.fail(e, false);
            }
        }
    }

    public void close() {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (!this.opened) {
                throw new IllegalStateException("Cannot close a component context that is not opened");
            }
            this.opened = false;
            if (this.getState() == ComponentState.ACTIVE) {
                this.stopping(ComponentState.INACTIVE);
            } else {
                this.closeReferenceHelpers();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private void closeReferenceHelpers() {
        for (ReferenceHelper<?, C, ?> referenceHelper : this.referenceHelpers) {
            if (!referenceHelper.isOpened()) continue;
            referenceHelper.close();
        }
    }

    private boolean equals(Object oldValue, Object newValue) {
        if (oldValue == null && newValue != null || oldValue != null && newValue == null) {
            return false;
        }
        if (oldValue != null && !oldValue.equals(newValue)) {
            Class<?> newValueClass;
            Class<?> oldValueClass = oldValue.getClass();
            if (!oldValueClass.equals(newValueClass = newValue.getClass()) || !oldValueClass.isArray()) {
                return false;
            }
            boolean equals = oldValueClass.equals(boolean[].class) ? Arrays.equals((boolean[])oldValue, (boolean[])newValue) : (oldValueClass.equals(byte[].class) ? Arrays.equals((byte[])oldValue, (byte[])newValue) : (oldValueClass.equals(char[].class) ? Arrays.equals((char[])oldValue, (char[])newValue) : (oldValueClass.equals(double[].class) ? Arrays.equals((double[])oldValue, (double[])newValue) : (oldValueClass.equals(float[].class) ? Arrays.equals((float[])oldValue, (float[])newValue) : (oldValueClass.equals(int[].class) ? Arrays.equals((int[])oldValue, (int[])newValue) : (oldValueClass.equals(long[].class) ? Arrays.equals((long[])oldValue, (long[])newValue) : (oldValueClass.equals(short[].class) ? Arrays.equals((short[])oldValue, (short[])newValue) : Arrays.equals((Object[])oldValue, (Object[])newValue))))))));
            if (!equals) {
                return false;
            }
        }
        return true;
    }

    public void fail(Throwable e, boolean permanent) {
        boolean stopComponent = false;
        if (this.getState() == ComponentState.ACTIVE) {
            stopComponent = true;
        }
        this.fail(e, permanent, stopComponent);
    }

    private void fail(Throwable e, boolean permanent, boolean stopComponent) {
        this.revisionBuilder.setOrAddSuppressedCause(e);
        if (this.isFailed()) {
            return;
        }
        if (stopComponent) {
            this.stopping(ComponentState.FAILED);
        } else {
            this.instance = null;
        }
        this.revisionBuilder.fail(e, permanent);
    }

    private void fillAttributeHelpers(AttributeMetadata<?>[] attributes) {
        for (AttributeMetadata<?> attributeMetadata : attributes) {
            ReferenceHelper helper;
            if (attributeMetadata instanceof PropertyAttributeMetadata) {
                PropertyAttributeHelper propertyAttributeHelper = new PropertyAttributeHelper(this, (PropertyAttributeMetadata)attributeMetadata);
                this.propertyAttributeHelpers.add(propertyAttributeHelper);
                continue;
            }
            try {
                helper = attributeMetadata instanceof ServiceReferenceMetadata ? new ServiceReferenceAttributeHelper((ServiceReferenceMetadata)attributeMetadata, this, this.referenceEventHandler) : new BundleCapabilityReferenceAttributeHelper((BundleCapabilityReferenceMetadata)attributeMetadata, this, this.referenceEventHandler);
            }
            catch (IllegalAccessException | RuntimeException e) {
                this.fail(e, true);
                return;
            }
            this.referenceHelpers.add(helper);
        }
    }

    private void freeReferences() {
        for (ReferenceHelper<?, C, ?> referenceHelper : this.referenceHelpers) {
            referenceHelper.free();
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public ComponentContainer<C> getComponentContainer() {
        return this.componentContainer;
    }

    public ComponentRevisionImpl<C> getComponentRevision() {
        return this.revisionBuilder.build();
    }

    public ServiceReference<?> getComponentServiceReference() {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            if (this.serviceRegistration == null) {
                ServiceReference<?> serviceReference = null;
                return serviceReference;
            }
            ServiceReference serviceReference = this.serviceRegistration.getReference();
            return serviceReference;
        }
        finally {
            readLock.unlock();
        }
    }

    public Class<C> getComponentType() {
        return this.componentType;
    }

    public C getInstance() {
        return this.instance;
    }

    public Map<String, Object> getProperties() {
        return this.revisionBuilder.getProperties();
    }

    public ComponentState getState() {
        return this.revisionBuilder.getState();
    }

    public boolean isFailed() {
        ComponentState state = this.getState();
        return ComponentState.FAILED == state || ComponentState.FAILED_PERMANENT == state;
    }

    public boolean isSatisfied() {
        return this.satisfiedReferences == this.referenceHelpers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.opened) {
                throw new IllegalStateException("Cannot open a component context that is already opened");
            }
            this.opened = true;
            if (this.getState() != ComponentState.INACTIVE) {
                return;
            }
            this.revisionBuilder.updateProperties(this.revisionBuilder.getProperties());
            if (this.referenceHelpers.size() == 0) {
                this.starting();
            } else {
                for (ReferenceHelper<?, C, ?> referenceAttributeHelper : this.referenceHelpers) {
                    referenceAttributeHelper.open();
                }
                if (this.isFailed()) {
                    return;
                }
                if (this.isSatisfied()) {
                    this.starting();
                } else {
                    this.revisionBuilder.unsatisfied();
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private void prepareConfigurationUpdate(ComponentState stateBeforeUpdate, Map<String, Object> newProperties) {
        if (stateBeforeUpdate == ComponentState.ACTIVE && this.shouldRestartForNewConfiguraiton(newProperties)) {
            this.stopping(ComponentState.UPDATING_CONFIGURATION);
        } else if (stateBeforeUpdate == ComponentState.UNSATISFIED || stateBeforeUpdate == ComponentState.FAILED) {
            this.revisionBuilder.updatingConfiguration();
        }
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        this.validateComponentStateForServiceRegistration();
        ServiceRegistration lServiceRegistration = this.bundleContext.registerService(clazz, service, properties);
        return this.registerServiceInternal(lServiceRegistration);
    }

    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        this.validateComponentStateForServiceRegistration();
        ServiceRegistration lServiceRegistration = this.bundleContext.registerService(clazz, service, properties);
        return this.registerServiceInternal(lServiceRegistration);
    }

    public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
        this.validateComponentStateForServiceRegistration();
        ServiceRegistration lServiceRegistration = this.bundleContext.registerService(clazzes, service, properties);
        return this.registerServiceInternal(lServiceRegistration);
    }

    private <S> ServiceRegistration<S> registerServiceInternal(ServiceRegistration<S> original) {
        ComponentServiceRegistration componentServiceRegistration = new ComponentServiceRegistration(this, original);
        this.revisionBuilder.addServiceRegistration(componentServiceRegistration);
        return componentServiceRegistration;
    }

    void removeServiceRegistration(ServiceRegistration<?> pServiceRegistration) {
        this.revisionBuilder.removeServiceRegistration(pServiceRegistration);
    }

    private Method resolveAnnotatedMethod(String methodType, MethodDescriptor methodDescriptor) {
        IllegalMetadataException exception;
        if (methodDescriptor == null) {
            return null;
        }
        Method method = methodDescriptor.locate(this.componentType, false);
        if (method == null) {
            exception = new IllegalMetadataException("Could not find " + methodType + " method '" + methodDescriptor.toString() + "' for type " + this.componentType);
            this.fail(exception, true);
        }
        if (method.getParameterTypes().length > 0) {
            exception = new IllegalMetadataException(methodType.substring(0, 1).toUpperCase(Locale.getDefault()) + methodType.substring(1) + " method must not have any parameters. Method '" + method.toGenericString() + "' of type " + this.componentType + " does have.");
            this.fail(exception, true);
        }
        return method;
    }

    private Map<String, Object> resolveProperties(Dictionary<String, ?> props) {
        AttributeMetadata[] attributes;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (props != null) {
            Enumeration<?> elements = props.elements();
            Enumeration<String> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Object element = elements.nextElement();
                result.put(key, element);
            }
        }
        for (AttributeMetadata attributeMetadata : attributes = this.componentContainer.getComponentMetadata().getAttributes()) {
            Object value;
            String attributeId = attributeMetadata.getAttributeId();
            if (result.containsKey(attributeId)) continue;
            Object defaultValue = attributeMetadata.getDefaultValue();
            if (attributeMetadata.isMultiple() && defaultValue != null) {
                result.put(attributeId, defaultValue);
                continue;
            }
            if (defaultValue == null || Array.getLength(defaultValue) <= 0 || (value = Array.get(defaultValue, 0)) == null) continue;
            result.put(attributeId, value);
        }
        return Collections.unmodifiableMap(result);
    }

    private String[] resolveServiceInterfaces() {
        ServiceMetadata serviceMetadata = this.componentContainer.getComponentMetadata().getService();
        if (serviceMetadata == null) {
            return new String[0];
        }
        Class[] clazzes = serviceMetadata.getClazzes();
        if (clazzes.length > 0) {
            String[] result = new String[clazzes.length];
            for (int i = 0; i < clazzes.length; ++i) {
                result[i] = clazzes[i].getName();
            }
            return result;
        }
        HashSet<String> interfaces = new HashSet<String>();
        Class<C> currentClass = this.componentType;
        ComponentContextImpl.resolveSuperInterfacesRecurse(currentClass, interfaces);
        if (interfaces.size() != 0) {
            return interfaces.toArray(new String[interfaces.size()]);
        }
        return new String[]{this.componentType.getName()};
    }

    private void restart() {
        this.stopping(ComponentState.STOPPING);
        this.starting();
    }

    private boolean shouldRestartForNewConfiguraiton(Map<String, Object> newProperties) {
        AttributeMetadata[] componentAttributes = this.componentContainer.getComponentMetadata().getAttributes();
        Map<String, Object> properties = this.getProperties();
        for (AttributeMetadata attributeMetadata : componentAttributes) {
            Object newValue;
            String attributeId;
            Object oldValue;
            if (attributeMetadata.isDynamic() || this.equals(oldValue = properties.get(attributeId = attributeMetadata.getAttributeId()), newValue = newProperties.get(attributeId))) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void starting() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void stopping(ComponentState targetState) {
        block18: {
            try {
                this.revisionBuilder.stopping();
                if (this.serviceRegistration != null) {
                    this.serviceRegistration.unregister();
                    this.serviceRegistration = null;
                }
                if (this.instance == null) break block18;
                if (this.deactivateMethod != null) {
                    try {
                        this.deactivateMethod.invoke(this.instance, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        if (targetState == ComponentState.FAILED) {
                            this.revisionBuilder.setOrAddSuppressedCause(e);
                        }
                        e.printStackTrace(System.err);
                    }
                }
                this.unregisterServices();
                this.freeReferences();
                this.instance = null;
            }
            finally {
                switch (targetState) {
                    case INACTIVE: {
                        this.revisionBuilder.inactive();
                        break;
                    }
                    case UNSATISFIED: {
                        this.revisionBuilder.unsatisfied();
                        break;
                    }
                    case UPDATING_CONFIGURATION: {
                        this.revisionBuilder.updatingConfiguration();
                        break;
                    }
                }
            }
        }
    }

    private void unregisterServices() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
        for (ServiceRegistration<?> lServiceRegistration : this.revisionBuilder.getCloneOfServiceRegistrations()) {
            this.revisionBuilder.removeServiceRegistration(lServiceRegistration);
            lServiceRegistration.unregister();
        }
    }

    public void updateConfiguration(Dictionary<String, ?> properties) {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.getState() == ComponentState.FAILED_PERMANENT) {
                return;
            }
            this.updateConfigurationInLock(properties);
        }
        finally {
            writeLock.unlock();
        }
    }

    private void updateConfigurationInLock(Dictionary<String, ?> properties) {
        this.configurationUpdateInProgress = true;
        ComponentState stateBeforeUpdate = this.getState();
        Map<String, Object> oldProperties = this.getProperties();
        Map<String, Object> newProperties = this.resolveProperties(properties);
        this.prepareConfigurationUpdate(stateBeforeUpdate, newProperties);
        this.revisionBuilder.updateProperties(newProperties);
        this.updateReferences(newProperties, oldProperties);
        ComponentState stateAfterReferenceUpdate = this.getState();
        if (stateAfterReferenceUpdate == ComponentState.UNSATISFIED || this.isFailed()) {
            return;
        }
        if (!this.isSatisfied()) {
            this.revisionBuilder.unsatisfied();
        } else if (stateAfterReferenceUpdate == ComponentState.UPDATING_CONFIGURATION) {
            this.starting();
        } else {
            this.updatePropertiesOnComponentInstance(newProperties, oldProperties);
            if (this.isFailed()) {
                return;
            }
            this.callUpdateMethod();
            this.configurationUpdateInProgress = false;
        }
        if (this.serviceRegistration != null) {
            this.serviceRegistration.setProperties(new Hashtable<String, Object>(newProperties));
        }
    }

    private void updatePropertiesOnComponentInstance(Map<String, Object> newProperties, Map<String, Object> oldProperties) {
        for (PropertyAttributeHelper<C, Object> helper : this.propertyAttributeHelpers) {
            Object newValue;
            String attributeId = helper.getAttributeMetadata().getAttributeId();
            Object oldValue = oldProperties.get(attributeId);
            if (this.equals(oldValue, newValue = newProperties.get(attributeId))) continue;
            helper.applyValue(newValue);
            if (!this.isFailed()) continue;
            return;
        }
    }

    private void updateReferences(Map<String, Object> newProperties, Map<String, Object> oldProperties) {
        for (ReferenceHelper<?, C, ?> referenceHelper : this.referenceHelpers) {
            String attributeId = referenceHelper.getReferenceMetadata().getAttributeId();
            Object newValue = newProperties.get(attributeId);
            Object oldValue = oldProperties.get(attributeId);
            if (!this.equals(oldValue, newValue)) {
                referenceHelper.updateConfiguration();
                if (this.isFailed()) {
                    return;
                }
            }
            if (referenceHelper.isOpened()) continue;
            referenceHelper.open();
            if (!this.isFailed()) continue;
            return;
        }
    }

    private void validateComponentStateForServiceRegistration() {
        ComponentState state = this.getState();
        if (state != ComponentState.ACTIVE && state != ComponentState.STARTING) {
            throw new IllegalStateException("Service can only be registered in component if the state of the component is ACTIVE or STARTING");
        }
    }

    private class ReferenceEventHandlerImpl
    implements ReferenceEventHandler {
        private ReferenceEventHandlerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void satisfied(ReferenceHelper<?, ?, ? extends ReferenceMetadata> referenceHelper) {
            Lock writeLock = ComponentContextImpl.this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                ComponentContextImpl.this.satisfiedReferences++;
                ComponentContextImpl.this.revisionBuilder.updateSuitingsForAttribute(referenceHelper.getReferenceMetadata(), referenceHelper.getSuitings());
                ComponentState state = ComponentContextImpl.this.getState();
                if (ComponentContextImpl.this.satisfiedReferences == ComponentContextImpl.this.referenceHelpers.size() && (state == ComponentState.UNSATISFIED || state == ComponentState.FAILED)) {
                    ComponentContextImpl.this.starting();
                }
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void unsatisfied(ReferenceHelper<?, ?, ? extends ReferenceMetadata> referenceHelper) {
            Lock writeLock = ComponentContextImpl.this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                ComponentContextImpl.this.satisfiedReferences--;
                ComponentContextImpl.this.revisionBuilder.updateSuitingsForAttribute(referenceHelper.getReferenceMetadata(), referenceHelper.getSuitings());
                ComponentState state = ComponentContextImpl.this.getState();
                if (state == ComponentState.ACTIVE) {
                    ComponentContextImpl.this.stopping(ComponentState.UNSATISFIED);
                } else if (state == ComponentState.FAILED) {
                    ComponentContextImpl.this.revisionBuilder.unsatisfied();
                }
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateDynamicWithoutSatisfactionChange(ReferenceHelper<?, ?, ? extends ReferenceMetadata> referenceHelper) {
            Lock writeLock = ComponentContextImpl.this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                ComponentContextImpl.this.revisionBuilder.updateSuitingsForAttribute(referenceHelper.getReferenceMetadata(), referenceHelper.getSuitings());
                ComponentState state = ComponentContextImpl.this.getState();
                if (state == ComponentState.ACTIVE) {
                    referenceHelper.bind();
                    if (ComponentContextImpl.this.getState() == ComponentState.ACTIVE && !ComponentContextImpl.this.configurationUpdateInProgress) {
                        ComponentContextImpl.this.callUpdateMethod();
                    }
                } else if (state == ComponentState.FAILED && !ComponentContextImpl.this.configurationUpdateInProgress) {
                    ComponentContextImpl.this.starting();
                }
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateNonDynamic(ReferenceHelper<?, ?, ? extends ReferenceMetadata> referenceHelper) {
            Lock writeLock = ComponentContextImpl.this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                ComponentState state = ComponentContextImpl.this.getState();
                if (state == ComponentState.ACTIVE) {
                    ComponentContextImpl.this.revisionBuilder.stopping();
                }
                ComponentContextImpl.this.revisionBuilder.updateSuitingsForAttribute(referenceHelper.getReferenceMetadata(), referenceHelper.getSuitings());
                if (state == ComponentState.ACTIVE) {
                    ComponentContextImpl.this.restart();
                } else if (state == ComponentState.FAILED) {
                    ComponentContextImpl.this.starting();
                }
            }
            finally {
                writeLock.unlock();
            }
        }
    }
}

