/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.bnd;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Resource;
import aQute.bnd.version.Version;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class ECMClassDataCollector
extends ClassDataCollector {
    private static final String LOCALIZED_VALUE_PREFIX = "%";
    private boolean allInterfacesAppended = false;
    private final Analyzer analyzer;
    private final Clazz clazz;
    private String componentId;
    private String description;
    private String label;
    private Properties localizationProperties = null;
    private final Collection<Collection<String>> servicesWithInterfaces = new LinkedHashSet<Collection<String>>();
    private Version version;

    public ECMClassDataCollector(Clazz clazz, Analyzer analyzer) {
        this.clazz = clazz;
        this.analyzer = analyzer;
    }

    private void addAllInterfaceRecurse(Clazz currentClazz, Set<String> interfaceNames) {
        if (currentClazz == null) {
            return;
        }
        if (currentClazz.isInterface()) {
            interfaceNames.add(currentClazz.getFQN());
        }
        Clazz superClazzTypeRef = this.resolveClazzByTypeRef(currentClazz.getSuper());
        this.addAllInterfaceRecurse(superClazzTypeRef, interfaceNames);
        Descriptors.TypeRef[] interfaces = currentClazz.getInterfaces();
        if (interfaces != null) {
            for (Descriptors.TypeRef typeRef : interfaces) {
                Clazz interfaceClazz = this.resolveClazzByTypeRef(typeRef);
                this.addAllInterfaceRecurse(interfaceClazz, interfaceNames);
            }
        }
    }

    public void annotation(Annotation annotation) throws Exception {
        String annotationFQN;
        switch (annotationFQN = annotation.getName().getFQN()) {
            case "org.everit.osgi.ecm.annotation.Component": {
                this.handleComponentAnnotation(annotation);
                break;
            }
            case "org.everit.osgi.ecm.annotation.ManualServices": {
                this.handleManualServicesAnnotation(annotation);
                break;
            }
            case "org.everit.osgi.ecm.annotation.Service": {
                this.handleServiceAnnotation(annotation);
                break;
            }
        }
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    private Properties getLocalizedProperties(Annotation componentAnnotation) throws Exception {
        if (this.localizationProperties != null) {
            return this.localizationProperties;
        }
        this.localizationProperties = new Properties();
        String localizationBase = (String)componentAnnotation.get("localizationBase");
        if (localizationBase == null) {
            localizationBase = "OSGI-INF/metatype/metatype";
        } else if (localizationBase.trim().equals("")) {
            return this.localizationProperties;
        }
        Resource localizationFile = this.analyzer.getJar().getResource(localizationBase + ".properties");
        if (localizationFile == null) {
            return this.localizationProperties;
        }
        try (InputStream in = localizationFile.openInputStream();){
            this.localizationProperties.load(in);
        }
        return this.localizationProperties;
    }

    public Collection<Collection<String>> getServicesWithInterfaces() {
        return this.servicesWithInterfaces;
    }

    public Version getVersion() {
        return this.version;
    }

    private void handleComponentAnnotation(Annotation annotation) {
        this.componentId = this.resolveComponentId(annotation);
        this.label = this.resolveLabel(annotation);
        this.description = this.resolveDescription(annotation);
        this.version = this.resolveVersion(annotation);
    }

    private void handleManualServicesAnnotation(Annotation annotation) {
        Object[] value;
        for (Object annotationObj : value = (Object[])annotation.get("value")) {
            this.handleServiceAnnotation((Annotation)annotationObj);
        }
    }

    private void handleServiceAnnotation(Annotation annotation) {
        Object[] typeArray = (Object[])annotation.get("value");
        LinkedHashSet<String> interfaceNames = new LinkedHashSet<String>();
        if (typeArray != null && typeArray.length > 0) {
            for (Object typeRefObj : typeArray) {
                interfaceNames.add(((Descriptors.TypeRef)typeRefObj).getFQN());
            }
        }
        if (interfaceNames.size() > 0) {
            this.servicesWithInterfaces.add(interfaceNames);
        } else if (!this.allInterfacesAppended) {
            this.allInterfacesAppended = true;
            this.addAllInterfaceRecurse(this.clazz, interfaceNames);
            if (interfaceNames.size() == 0) {
                interfaceNames.add(this.clazz.getFQN());
            }
            this.servicesWithInterfaces.add(interfaceNames);
        }
    }

    private Clazz resolveClazzByTypeRef(Descriptors.TypeRef typeRef) {
        if (typeRef == null) {
            return null;
        }
        try {
            return this.analyzer.findClass(typeRef);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String resolveComponentId(Annotation componentAnnotation) {
        String componentId = (String)componentAnnotation.get("componentId");
        if (componentId != null) {
            return componentId;
        }
        return this.clazz.getFQN();
    }

    private String resolveDescription(Annotation annotation) {
        String result = (String)annotation.get("description");
        if (result == null || "".equals(result.trim())) {
            return null;
        }
        if (result.startsWith(LOCALIZED_VALUE_PREFIX)) {
            result = this.resolveLocalizedValue(result, annotation);
        }
        return result;
    }

    private String resolveLabel(Annotation annotation) {
        String result = (String)annotation.get("label");
        if (result == null || "".equals(result.trim())) {
            return this.componentId;
        }
        if (result.startsWith(LOCALIZED_VALUE_PREFIX)) {
            result = this.resolveLocalizedValue(result, annotation);
        }
        return result;
    }

    private String resolveLocalizedValue(String localizedValue, Annotation componentAnnotation) {
        String result = localizedValue.substring(1);
        try {
            Properties props = this.getLocalizedProperties(componentAnnotation);
            return props.getProperty(result, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Version resolveVersion(Annotation annotation) {
        String versionValue = (String)annotation.get("version");
        if (versionValue == null) {
            return new Version(this.analyzer.getVersion());
        }
        return new Version(versionValue);
    }
}

