/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.ecm.bnd;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.service.AnalyzerPlugin;
import java.util.ArrayList;
import java.util.Collection;
import org.everit.osgi.ecm.bnd.ECMClassDataCollector;

public class ECMBndAnalyzerPlugin
implements AnalyzerPlugin {
    private void addComponentCapability(ECMClassDataCollector ecmClassDataCollector, Collection<Parameters> provides) {
        Attrs attrs = new Attrs();
        attrs.put("componentId", ecmClassDataCollector.getComponentId());
        attrs.putTyped("version", (Object)ecmClassDataCollector.getVersion());
        attrs.put("class", ecmClassDataCollector.getClazz().getFQN());
        attrs.put("label", ecmClassDataCollector.getLabel());
        String description = ecmClassDataCollector.getDescription();
        if (description != null) {
            attrs.put("description", description);
        }
        Parameters parameters = new Parameters();
        parameters.put("org.everit.osgi.ecm.component", attrs);
        provides.add(parameters);
    }

    private void addOSGiServiceCapabilities(ECMClassDataCollector ecmClassDataCollector, Collection<Parameters> provides) {
        String componentId = ecmClassDataCollector.getComponentId();
        Collection<Collection<String>> servicesWithInterfaces = ecmClassDataCollector.getServicesWithInterfaces();
        for (Collection<String> serviceInterfaces : servicesWithInterfaces) {
            Attrs attrs = new Attrs();
            attrs.putTyped("objectClass", serviceInterfaces);
            attrs.put("org.everit.osgi.ecm.component.id", componentId);
            attrs.putTyped("org.everit.osgi.ecm.component.version", (Object)ecmClassDataCollector.getVersion());
            Parameters parameters = new Parameters();
            parameters.put("osgi.service", attrs);
            provides.add(parameters);
        }
    }

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Collection classes = analyzer.getClasses(new String[]{"getComponentClasses", Clazz.QUERY.ANNOTATED.name(), "org.everit.osgi.ecm.annotation.Component"});
        ArrayList<Parameters> provides = new ArrayList<Parameters>();
        for (Clazz clazz : classes) {
            ECMClassDataCollector ecmClassDataCollector = new ECMClassDataCollector(clazz, analyzer);
            clazz.parseClassFileWithCollector((ClassDataCollector)ecmClassDataCollector);
            this.processCollectedClassData(ecmClassDataCollector, provides);
        }
        StringBuilder sb = new StringBuilder();
        for (Parameters parameters : provides) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(parameters.toString());
        }
        analyzer.setProperty("Provide-Capability", sb.toString());
        return false;
    }

    private void processCollectedClassData(ECMClassDataCollector ecmClassDataCollector, Collection<Parameters> provides) {
        this.addComponentCapability(ecmClassDataCollector, provides);
        this.addOSGiServiceCapabilities(ecmClassDataCollector, provides);
    }
}

