/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.authnr.permissionchecker.ri.internal;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.everit.osgi.authentication.context.AuthenticationContext;
import org.everit.osgi.authnr.permissionchecker.AuthnrPermissionChecker;
import org.everit.osgi.authorization.PermissionChecker;

@Component(name="org.everit.osgi.authnr.permissionchecker.ri.AuthnrPermissionChecker", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true)
@Properties(value={@Property(name="service.description", propertyPrivate=false, value={"Default Authenticated Authorization Permission Checker"}), @Property(name="authenticationContext.target"), @Property(name="permissionChecker.target")})
@Service
public class AuthnrPermissionCheckerComponent
implements AuthnrPermissionChecker {
    @Reference(bind="setAuthenticationContext")
    private AuthenticationContext authenticationContext;
    @Reference(bind="setPermissionChecker")
    private PermissionChecker permissionChecker;

    public long[] getAuthorizationScope() {
        long authorizedResourceId = this.authenticationContext.getCurrentResourceId();
        return this.permissionChecker.getAuthorizationScope(authorizedResourceId);
    }

    public long getSystemResourceId() {
        return this.permissionChecker.getSystemResourceId();
    }

    public boolean hasPermission(long targetResourceId, String ... actions) {
        long authorizedResourceId = this.authenticationContext.getCurrentResourceId();
        return this.permissionChecker.hasPermission(authorizedResourceId, targetResourceId, actions);
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setPermissionChecker(PermissionChecker permissionChecker) {
        this.permissionChecker = permissionChecker;
    }

    protected void unbindAuthenticationContext(AuthenticationContext authenticationContext) {
        if (this.authenticationContext == authenticationContext) {
            this.authenticationContext = null;
        }
    }

    protected void unbindPermissionChecker(PermissionChecker permissionChecker) {
        if (this.permissionChecker == permissionChecker) {
            this.permissionChecker = null;
        }
    }
}

